/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.collections;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.util.collections.CompoundIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CompoundDisplayDescriptorCollection
implements DisplayDescriptorCollection {
    private final DisplayDescriptorCollection[] _collections;

    public CompoundDisplayDescriptorCollection(DisplayDescriptorCollection ... collections) {
        this._collections = collections;
    }

    @Override
    public boolean add(DisplayDescriptor pd) {
        return this._collections[0].add(pd);
    }

    public boolean remove(DisplayDescriptor pd) {
        return this._collections[0].remove(pd);
    }

    public void removeAll(DisplayDescriptorCollection collection) {
        this._collections[0].removeAll(collection);
    }

    public void addAll(DisplayDescriptorCollection collection) {
        this._collections[0].addAll(collection);
    }

    @Override
    public int size() {
        int size = 0;
        for (DisplayDescriptorCollection c : this._collections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (DisplayDescriptorCollection c : this._collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof DisplayDescriptor) {
            return this.contains((DisplayDescriptor)o);
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (DisplayDescriptorCollection c : this._collections) {
            Object[] cArray = c.toArray();
            CompoundDisplayDescriptorCollection.copy(cArray, array, index);
            index += cArray.length;
        }
        return array;
    }

    private static <T> void copy(T[] src, T[] dest, int start) {
        System.arraycopy(src, 0, dest, start, src.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int index = 0;
        for (DisplayDescriptorCollection c : this._collections) {
            Object[] cArray = c.toArray();
            CompoundDisplayDescriptorCollection.copy(cArray, a, index);
            index += cArray.length;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof DisplayDescriptor) {
            return this.remove((DisplayDescriptor)o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends DisplayDescriptor> c) {
        return this._collections[0].addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends DisplayDescriptor> c) {
        return this._collections[0].addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._collections[0].removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._collections[0].removeAll(c);
    }

    @Override
    public void clear() {
        this._collections[0].clear();
    }

    @Override
    public DisplayDescriptor get(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DisplayDescriptor set(int index, DisplayDescriptor element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(int index, DisplayDescriptor element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DisplayDescriptor remove(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<DisplayDescriptor> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<DisplayDescriptor> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<DisplayDescriptor> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<DisplayDescriptor> iterator() {
        return new CompoundIterator((Iterable[])this._collections);
    }

    @Override
    public boolean contains(DisplayDescriptor pd) {
        for (DisplayDescriptorCollection collection : this._collections) {
            if (!collection.contains(pd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DisplayDescriptor get(String name) {
        for (DisplayDescriptor d : this) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    @Override
    public boolean contains(String name) {
        for (DisplayDescriptor d : this) {
            if (!d.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

