/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.view.editor.TransformsByInputFilter;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TransformFilterUtils {
    private TransformFilterUtils() {
    }

    public static List<TransformDefinition> getTransforms(TransformServerInfo tas, String inputType) {
        TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
        TransformRepository remote = registry.getRepository(tas.getDefaultRepository());
        Set allMatchedTransforms = remote.find((TransformFilter)new TransformsByInputFilter(inputType));
        ArrayList<TransformDefinition> tasMatchedTransforms = new ArrayList<TransformDefinition>();
        Set tasTransforms = tas.getTransforms();
        for (TransformDefinition transform : allMatchedTransforms) {
            if (!tasTransforms.contains(transform.getName())) continue;
            tasMatchedTransforms.add(transform);
        }
        return tasMatchedTransforms;
    }

    public static String getSelectedType(Object selectedOption) {
        MaltegoEntitySpec selectedEntitySpec = selectedOption instanceof MaltegoEntitySpec ? (MaltegoEntitySpec)selectedOption : (MaltegoEntitySpec)EntityRegistry.getDefault().get("maltego.Unknown");
        return selectedEntitySpec.getTypeName();
    }
}

