/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.treelist;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.RuntimeState;
import com.paterva.maltego.automation.treelist.MachineRunProvider;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.runregistry.item.AbstractRunProviderItem;
import com.paterva.maltego.runregistry.item.RunningItem;
import com.paterva.maltego.util.StringUtilities;
import org.openide.util.Utilities;

public class MachineRunningItem
extends AbstractRunProviderItem
implements RunningItem {
    private final MachineDescriptor _machine;
    private final String _name;
    private RuntimeState _state;
    private String _message;

    public MachineRunningItem(MachineDescriptor machine) {
        this._machine = machine;
        this._name = machine.getName() + "." + Guid.create();
    }

    public void setState(RuntimeState state) {
        if (this._state != state) {
            this._state = state;
            this.fireItemChanged();
        }
    }

    public void setMessage(String message) {
        if (!Utilities.compareObjects((Object)this._message, (Object)message)) {
            this._message = message;
            this.fireItemChanged();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._machine.getDisplayName();
    }

    public String getDescription() {
        String description;
        String string = description = this._state != null ? this._state.name() : "";
        if (!StringUtilities.isNullOrEmpty((String)this._message)) {
            description = description + " - " + this._message;
        }
        return description;
    }

    public String getLafPrefix() {
        return "machines-item-running";
    }

    public boolean isShowIn(String componentName) {
        return MachineRunProvider.isShowIn(componentName);
    }
}

