/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.impl.AutomationContexts;
import com.paterva.maltego.automation.runtime.MachineProgressEvent;
import com.paterva.maltego.automation.runtime.MachineProgressListener;
import com.paterva.maltego.automation.runtime.MachineRunner;
import com.paterva.maltego.automation.runtime.MachineRuntime;
import com.paterva.maltego.automation.runtime.MachineRuntimeException;
import com.paterva.maltego.automation.runtime.State;
import com.paterva.maltego.automation.runtime.TimeKeeper;
import com.paterva.maltego.core.EntityID;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.openide.loaders.DataObject;

public class DefaultMachineRunner
extends MachineRunner {
    private final Map<MachineRuntime, AutomationContext> _machines = new HashMap<MachineRuntime, AutomationContext>();

    @Override
    public void start(MachineRuntime runtime, DataObject target, Payload payload) throws MachineRuntimeException {
        DefaultAutomationContext ctx = new DefaultAutomationContext(runtime, target, payload);
        ctx.setGlobal("machine-name", runtime.getName());
        this._machines.put(runtime, ctx);
        runtime.addMachineProgressListener(new MachineProgressListener(){

            @Override
            public void machineProgress(MachineProgressEvent event) {
                if (event.getNewState() == State.Completed || event.getNewState() == State.Cancelled || event.getNewState() == State.Failed) {
                    DefaultMachineRunner.this._machines.remove((MachineRuntime)event.getSource());
                }
            }
        });
        this.start(runtime, ctx);
        TimeKeeper.getDefault().start(runtime, ctx);
    }

    private void start(MachineRuntime runtime, AutomationContext ctx) throws MachineRuntimeException {
        runtime.start(ctx, ctx.getInitialPayload());
    }

    @Override
    public boolean handleEvent(MachineRuntime machine, Object eventName, Object eventParam) {
        if ("timer".equals(eventName)) {
            AutomationContext ctx = this._machines.get(machine);
            if (ctx == null) {
                return false;
            }
            try {
                this.start(machine, ctx);
            }
            catch (MachineRuntimeException ex) {
                MachineMessageHandler.getDefault().error(ctx.getTarget(), String.format("Error starting machine: %s", ex.getMessage()), new Object[0]);
            }
            return true;
        }
        if ("waiting-tick".equals(eventName)) {
            int tick = (Integer)eventParam;
            machine.timerIdle(tick);
        }
        return false;
    }

    @Override
    public void stop(MachineRuntime runtime) {
        runtime.stop();
        this._machines.remove(runtime);
        TimeKeeper.getDefault().stop(runtime);
    }

    @Override
    public void suspend(MachineRuntime runtime) {
        runtime.suspend();
    }

    @Override
    public void resume(MachineRuntime runtime) {
        runtime.resume();
    }

    private static class DefaultAutomationContext
    extends AutomationContexts.ReadOnly {
        private final Map<EntityID, Map<Object, Object>> _properties = new HashMap<EntityID, Map<Object, Object>>();
        private final Map<Object, Object> _globals = new HashMap<Object, Object>();
        private final MachineRuntime _runtime;

        public DefaultAutomationContext(MachineRuntime runtime, DataObject target, Payload payload) {
            super(target, payload);
            this._runtime = runtime;
        }

        @Override
        public Object getGlobal(Object key) {
            return this._globals.get(key);
        }

        @Override
        public void setGlobal(Object key, Object value) {
            this._globals.put(key, value);
        }

        @Override
        public Object getProperty(EntityID entityID, Object key) {
            Map<Object, Object> map = this._properties.get(entityID);
            if (map != null) {
                return map.get(key);
            }
            return null;
        }

        @Override
        public void setProperty(EntityID entityID, Object key, Object value) {
            this.setProperty(entityID, key, value, true);
        }

        @Override
        public void setProperty(EntityID entityID, Object key, Object value, boolean overwrite) {
            Map<Object, Object> map = this._properties.get(entityID);
            if (map == null) {
                map = new TreeMap<Object, Object>();
                this._properties.put(entityID, map);
            }
            if (overwrite || !map.containsKey(key)) {
                map.put(key, value);
            }
        }

        @Override
        public void clearProperties(EntityID entityID) {
            this._properties.remove(entityID);
        }

        @Override
        public void progress(String message, int percent) {
            this._runtime.reportProgress(message, percent);
        }
    }
}

