/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.imex.MachineAttributesEntry;
import com.paterva.maltego.automation.imex.MachineAttributesWrapper;
import com.paterva.maltego.automation.imex.MachineConfig;
import com.paterva.maltego.automation.imex.MachineEntry;
import com.paterva.maltego.automation.imex.MachineWrapper;
import com.paterva.maltego.automation.imex.SelectableMachine;
import com.paterva.maltego.automation.imex.Util;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.util.Exceptions;

public class MachineExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        try {
            Collection<? extends MachineDescriptor> machines = MachineRepository.getDefault().getAll();
            if (!machines.isEmpty()) {
                return new MachineConfig(Util.createSelectables(machines));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        MachineConfig machineConfig = (MachineConfig)config;
        ArrayList<String> names = new ArrayList<String>();
        for (SelectableMachine selectable : machineConfig.getSelectedMachines()) {
            if (!selectable.isSelected()) continue;
            MachineDescriptor machine = selectable.getMachine();
            String fileName = this.getFileName(machine, names);
            writer.write((Entry)new MachineEntry(new MachineWrapper(fileName, machine)));
            writer.write((Entry)new MachineAttributesEntry(new MachineAttributesWrapper(fileName, machine)));
        }
        return names.size();
    }

    private String getFileName(MachineDescriptor machine, List<String> names) {
        String name = machine.getName();
        String fileName = FileUtilities.replaceIllegalChars((String)name);
        fileName = StringUtilities.createUniqueString(names, (String)fileName);
        names.add(fileName);
        return fileName;
    }
}

