/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.DateFormatter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public abstract class ExportAction
extends AbstractAction {
    public ExportAction(String name) {
        super(name);
    }

    protected abstract String getExtension(AutomationContext var1, String var2);

    protected abstract void export(AutomationContext var1, Payload var2, FileObject var3, SA var4) throws IOException;

    protected void perform(AutomationContext ctx, Payload payload, String path, Boolean suffixDate, String dateFormat) {
        File file = new File(path);
        String extension = this.getExtension(ctx, path);
        try {
            File suffixedFile = this.getSuffixedFile(file, extension, suffixDate, dateFormat);
            File uniqueFile = suffixedFile.exists() ? this.getUniqueFile(suffixedFile, extension) : suffixedFile;
            GraphDataObject graphDataObject = (GraphDataObject)ctx.getTarget();
            try {
                FileObject fileObject = FileUtil.createData((File)uniqueFile);
                GraphView graphView = this.getActiveGraphView(ctx);
                if (graphView != null) {
                    SA graph = graphView.getViewGraph();
                    this.export(ctx, payload, fileObject, graph);
                }
            }
            catch (IOException ex) {
                MachineMessageHandler.getDefault().error(ctx.getTarget(), "Error in %s: %s; %s", this.getName(), ex.getMessage(), file.getPath());
            }
        }
        catch (ParseException ex) {
            MachineMessageHandler.getDefault().error(ctx.getTarget(), "Invalid date format: %s", dateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        String path = (String)this.getValueOrProperty("path");
        Boolean suffixDate = (Boolean)this.getProperty("suffixDate", true);
        String dateFormat = (String)this.getProperty("dateFormat", "yyyyMMdd-HHmmssSSS");
        try {
            if (this.checkNonNullPath(ctx.getTarget(), path) && this.checkIsGraphDataObject(ctx.getTarget())) {
                this.perform(ctx, payload, path, suffixDate, dateFormat);
            }
        }
        finally {
            cb.completed(payload);
        }
    }

    private boolean checkNonNullPath(DataObject target, String path) {
        if (path == null) {
            MachineMessageHandler.getDefault().error(target, "Please specify a path for %s", this.getName());
            return false;
        }
        return true;
    }

    private boolean checkIsGraphDataObject(DataObject dataObject) {
        if (!(dataObject instanceof GraphDataObject)) {
            MachineMessageHandler.getDefault().error(dataObject, "Machine context is not a graph, cannot do %s.", this.getName());
            return false;
        }
        return true;
    }

    protected File getSuffixedFile(File file, String extension, boolean suffixDate, String dateFormat) throws ParseException {
        String name = ExportAction.removeExt(file.getName(), extension);
        if (suffixDate) {
            Date now = new Date();
            name = name + new DateFormatter(new SimpleDateFormat(dateFormat)).valueToString(now);
        }
        name = name.replaceAll("[^A-Za-z0-9_ \\-\\.]", "_");
        name = name + "." + extension;
        return new File(file.getParentFile(), name);
    }

    protected static String removeExt(String name, String extension) {
        return name.replaceFirst("(?i)\\." + extension + "$", "");
    }

    protected File getUniqueFile(File file, String extension) {
        return ExportAction.getUniqueFile(FileUtil.toFileObject((File)file.getParentFile()), ExportAction.removeExt(file.getName(), extension), extension);
    }

    protected static File getUniqueFile(FileObject folder, String filename, String extension) {
        String newName;
        FileObject file;
        int index = 0;
        do {
            newName = index > 0 ? filename + "_" + index : filename;
            newName = newName + "." + extension;
            file = folder.getFileObject(newName);
            ++index;
        } while (file != null);
        return new File(FileUtil.toFile((FileObject)folder), newName);
    }

    private GraphView getActiveGraphView(AutomationContext ctx) {
        TopComponent topComponent = ctx.getTopComponent();
        if (topComponent != null) {
            GraphViewCookie cookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class);
            if (cookie != null) {
                return cookie.getGraphView();
            }
        } else {
            MachineMessageHandler.getDefault().error(ctx.getTarget(), "Top component not found for machine.", new Object[0]);
        }
        return null;
    }
}

