/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.util.repository.AbstractRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.openide.util.Lookup;

public abstract class MachineRepository
extends AbstractRepository {
    public static MachineRepository getDefault() {
        MachineRepository manager = (MachineRepository)((Object)Lookup.getDefault().lookup(MachineRepository.class));
        if (manager == null) {
            manager = new TrivialMachineRepository();
        }
        return manager;
    }

    public abstract Collection<? extends MachineDescriptor> getAll() throws IOException;

    public Collection<? extends MachineDescriptor> getAll(boolean enabled) throws IOException {
        LinkedList<MachineDescriptor> list = new LinkedList<MachineDescriptor>();
        for (MachineDescriptor machineDescriptor : this.getAll()) {
            if (machineDescriptor.isEnabled() != enabled) continue;
            list.add(machineDescriptor);
        }
        return list;
    }

    public abstract void add(MachineDescriptor var1) throws IOException;

    public abstract void update(MachineDescriptor var1) throws IOException;

    public abstract void remove(MachineDescriptor var1) throws IOException;

    public abstract MachineDescriptor get(String var1) throws IOException;

    public boolean exists(String id) throws IOException {
        return this.get(id) != null;
    }

    private static class TrivialMachineRepository
    extends MachineRepository {
        private TrivialMachineRepository() {
        }

        @Override
        public Collection<? extends MachineDescriptor> getAll() {
            throw new UnsupportedOperationException("No MachineRepository registered.");
        }

        @Override
        public void add(MachineDescriptor descriptor) {
            throw new UnsupportedOperationException("No MachineRepository registered.");
        }

        @Override
        public void update(MachineDescriptor descriptor) {
            throw new UnsupportedOperationException("No MachineRepository registered.");
        }

        @Override
        public void remove(MachineDescriptor descriptor) {
            throw new UnsupportedOperationException("No MachineRepository registered.");
        }

        @Override
        public MachineDescriptor get(String id) {
            throw new UnsupportedOperationException("No MachineRepository registered.");
        }
    }
}

