/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.serialization;

import com.paterva.maltego.pws.api.OAuthAuthenticator;
import com.paterva.maltego.pws.api.OAuthAuthenticatorBuilder;
import com.paterva.maltego.pws.api.OAuthVersion;
import com.paterva.maltego.pws.api.PublicWebServiceFactory;
import com.paterva.maltego.pws.oauth.OAuthWebService;
import com.paterva.maltego.pws.serialization.OAuthServiceStub;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

public class OAuthServiceSerializer {
    public OAuthWebService read(InputStream is) throws XmlSerializationException, IOException, GeneralSecurityException {
        XmlSerializer serializer = new XmlSerializer();
        OAuthServiceStub stub = (OAuthServiceStub)serializer.read(OAuthServiceStub.class, is);
        return this.translate(stub);
    }

    public void write(OAuthWebService service, OutputStream os) throws XmlSerializationException, IOException, GeneralSecurityException {
        XmlSerializer serializer = new XmlSerializer();
        OAuthServiceStub stub = this.translate(service);
        serializer.write((Object)stub, os);
    }

    private OAuthWebService translate(OAuthServiceStub stub) throws IOException, GeneralSecurityException {
        OAuthAuthenticatorBuilder builder = OAuthAuthenticatorBuilder.getDefault();
        builder.accessTokenEndpoint(stub.getAccessTokenEndpoint());
        builder.accessTokenInput(stub.getAccessTokenInput());
        builder.accessTokenPublicKey(stub.getAccessTokenPublicKey());
        builder.appKey(StringUtilities.basicDecrypt((String)stub.getAppKey()));
        builder.appSecret(StringUtilities.basicDecrypt((String)stub.getAppSecret()));
        builder.authorizationUrl(stub.getAuthorizationUrl());
        builder.callbackPort(stub.getCallbackPort());
        builder.callbackPortUserModified(stub.isCallbackPortUserModified());
        builder.description(stub.getDescription());
        builder.displayName(stub.getDisplayName());
        builder.name(stub.getName());
        builder.oAuthVersion(OAuthVersion.parse((String)stub.getOAuthVersion()));
        builder.refreshTokenEndpoint(stub.getRefreshTokenEndpoint());
        builder.requestTokenEndpoint(stub.getRequestTokenEndpoint());
        builder.requestTypeForAccessToken(stub.getRequestTypeForAccessToken());
        builder.requestTypeForAuthorizationUrl(stub.getRequestTypeForAuthorizationUrl());
        builder.requestTypeForRequestToken(stub.getRequestTypeForRequestToken());
        builder.useSSLHost(stub.useSSLHost());
        builder.useSSLHostUserModified(stub.isUseSSLHostUserModified());
        OAuthAuthenticator authenticator = builder.build();
        OAuthWebService service = (OAuthWebService)PublicWebServiceFactory.getDefault().create(authenticator, false);
        service.setIconName(stub.getIconName());
        return service;
    }

    private OAuthServiceStub translate(OAuthWebService service) throws IOException, GeneralSecurityException {
        OAuthAuthenticator authenticator = service.getAuthenticator();
        OAuthServiceStub stub = new OAuthServiceStub();
        stub.setAccessTokenEndpoint(authenticator.getAccessTokenEndpoint());
        stub.setAccessTokenInput(authenticator.getAccessTokenInput());
        stub.setAccessTokenPublicKey(authenticator.getAccessTokenPublicKey());
        stub.setAppKey(StringUtilities.basicEncrypt((String)authenticator.getAppKey()));
        stub.setAppSecret(StringUtilities.basicEncrypt((String)authenticator.getAppSecret()));
        stub.setAuthorizationUrl(authenticator.getAuthorizationUrl());
        stub.setCallbackPort(authenticator.getCallbackPort());
        stub.setCallbackPortUserModified(authenticator.isCallbackPortUserModified());
        stub.setDescription(authenticator.getDescription());
        stub.setDisplayName(authenticator.getDisplayName());
        stub.setIconName(service.getIconName());
        stub.setName(authenticator.getName());
        stub.setOAuthVersion(authenticator.getOAuthVersion().toString());
        stub.setRefreshTokenEndpoint(authenticator.getRefreshTokenEndpoint());
        stub.setRequestTokenEndpoint(authenticator.getRequestTokenEndpoint());
        stub.setRequestTypeForAccessToken(authenticator.getRequestTypeForAccessToken());
        stub.setRequestTypeForRequestToken(authenticator.getRequestTypeForAuthorizationUrl());
        stub.setRequestTypeForRequestToken(authenticator.getRequestTypeForRequestToken());
        stub.setUseSSLHost(authenticator.useSSLHost());
        stub.setUseSSLHostUserModified(authenticator.isUseSSLHostUserModified());
        return stub;
    }
}

