/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import com.paterva.maltego.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

class TokenEncrypter {
    public static final String AES_TRANSFORMATION = "AES";
    private final PublicKey _publicKey;
    private final String _transformation;
    private SecretKey _aesKey;

    public TokenEncrypter(PublicKey publicKey, String transformation) {
        this(publicKey, transformation, null);
    }

    public TokenEncrypter(PublicKey publicKey, String transformation, SecretKey aesKey) {
        this._publicKey = publicKey;
        this._transformation = transformation;
        this._aesKey = aesKey;
    }

    public String encodeToken(String ... fields) throws GeneralSecurityException, IOException {
        if (this.isExceedsMaxLength(fields)) {
            return this.encodeTokenAes(fields);
        }
        return this.encodeTokenRsa(fields);
    }

    private boolean isExceedsMaxLength(String ... fields) {
        if (this._publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPk = (RSAPublicKey)RSAPublicKey.class.cast(this._publicKey);
            int max = rsaPk.getModulus().bitLength() / 8 - 11;
            for (String f : fields) {
                if (f.length() < max) continue;
                return true;
            }
        }
        return false;
    }

    private String encodeTokenRsa(String ... fields) throws GeneralSecurityException, IOException {
        Cipher cipher = Cipher.getInstance(this._transformation);
        cipher.init(1, this._publicKey);
        return TokenEncrypter.encodeToken(cipher, fields);
    }

    private String encodeTokenAes(String ... fields) throws GeneralSecurityException, IOException {
        Cipher rsaCipher = Cipher.getInstance(this._transformation);
        rsaCipher.init(1, this._publicKey);
        SecretKey secKey = this.getKey();
        Cipher aesCipher = Cipher.getInstance(AES_TRANSFORMATION);
        aesCipher.init(1, secKey);
        String encryptedKey = Base64.encodeBytes((byte[])TokenEncrypter.encrypt(rsaCipher, Base64.encodeBytes((byte[])secKey.getEncoded())));
        String prefix = TokenEncrypter.encodeToken(aesCipher, fields);
        return String.format("%s$%s", prefix, encryptedKey);
    }

    private static String encodeToken(Cipher cipher, String ... fields) throws GeneralSecurityException, IOException {
        return Stream.of(fields).map(b -> TokenEncrypter.encrypt(cipher, b)).map(Base64::encodeBytes).collect(Collectors.joining("$"));
    }

    private static byte[] encrypt(Cipher cipher, String text) {
        try {
            return cipher.doFinal(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    private SecretKey getKey() throws NoSuchAlgorithmException {
        if (this._aesKey == null) {
            KeyGenerator generator = KeyGenerator.getInstance(AES_TRANSFORMATION);
            generator.init(256);
            this._aesKey = generator.generateKey();
        }
        return this._aesKey;
    }
}

