/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.json.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MaltegoIDKeyPair {
    private final String publicKeyBase64;
    private final String privateKeyBase64;
    private final String signatureBlob;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public MaltegoIDKeyPair(@JsonProperty(value="publicKeyBase64", required=false) String publicKeyBase64, @JsonProperty(value="privateKeyBase64", required=false) String privateKeyBase64, @JsonProperty(value="signatureBlob", required=false) String signatureBlob) {
        this.publicKeyBase64 = publicKeyBase64;
        this.privateKeyBase64 = privateKeyBase64;
        this.signatureBlob = signatureBlob;
    }

    public String getPublicKeyBase64() {
        return this.publicKeyBase64;
    }

    public String getPrivateKeyBase64() {
        return this.privateKeyBase64;
    }

    public String getSignatureBlob() {
        return this.signatureBlob;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.publicKeyBase64);
        hash = 29 * hash + Objects.hashCode(this.privateKeyBase64);
        hash = 29 * hash + Objects.hashCode(this.signatureBlob);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaltegoIDKeyPair other = (MaltegoIDKeyPair)obj;
        if (!Objects.equals(this.publicKeyBase64, other.publicKeyBase64)) {
            return false;
        }
        if (!Objects.equals(this.privateKeyBase64, other.privateKeyBase64)) {
            return false;
        }
        return Objects.equals(this.signatureBlob, other.signatureBlob);
    }
}

