/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Link;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph {
    private final List<Entity> entities;
    private final List<Link> links;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Graph(@JsonProperty(value="entities") List<Entity> entities, @JsonProperty(value="links") List<Link> links) {
        this.entities = entities;
        this.links = links;
    }

    public Graph() {
        this.entities = new ArrayList<Entity>();
        this.links = new ArrayList<Link>();
    }

    public Graph(List<Entity> entities) {
        this.entities = entities;
        this.links = new ArrayList<Link>();
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public int getEntityCount() {
        return this.entities.size();
    }

    @JsonIgnore
    public int getLinkCount() {
        return this.links.size();
    }

    @JsonIgnore
    public int getRootEntityCount() {
        return this.getRootEntities().size();
    }

    public Entity addEntity(Entity entity) {
        this.entities.add(entity);
        return entity;
    }

    public Link addLink(Link link) {
        this.links.add(link);
        return link;
    }

    @JsonIgnore
    public Map<String, Integer> getEntityTypesStat() {
        return this.entities.stream().filter(entity -> entity.getBaseEntities() != null).flatMap(entity -> Stream.concat(entity.getBaseEntities().stream(), Stream.of(entity.getType()))).collect(Collectors.toMap(e -> e, e -> 1, Integer::sum));
    }

    @JsonIgnore
    public List<Entity> getRootEntities() {
        ArrayList<Entity> rootEntities = new ArrayList<Entity>();
        for (Entity entity : this.entities) {
            boolean isRoot = true;
            for (Link link : this.links) {
                if (!link.getTargetId().equals(entity.getId())) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootEntities.add(entity);
        }
        return rootEntities;
    }

    public String toString() {
        return "Graph{entities=" + this.entities + ", links=" + this.links + '}';
    }
}

