/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.discovery;

import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.discovery.CompositeDiscoveryConstraint;
import com.maltego.tx3.java.api.constraints.discovery.DiscoveryInputConstraint;
import com.maltego.tx3.java.api.constraints.discovery.EntityDiscoveryBaseEntityMatches;
import com.maltego.tx3.java.api.constraints.discovery.EntityDiscoveryCategoryMatches;
import com.maltego.tx3.java.api.constraints.discovery.EntityDiscoveryTypeMatches;
import com.maltego.tx3.java.api.constraints.discovery.PropertyDiscoveryExists;
import com.maltego.tx3.java.api.discovery.EntityDefinition;
import java.util.ArrayList;
import java.util.List;

public class DiscoveryConstraintBuilder {
    private final List<DiscoveryInputConstraint<EntityDefinition>> constraints = new ArrayList<DiscoveryInputConstraint<EntityDefinition>>();
    private LogicalOperation operation = LogicalOperation.ALL;

    public DiscoveryConstraintBuilder withEntityType(String type) {
        this.constraints.add(new EntityDiscoveryTypeMatches(type));
        return this;
    }

    public DiscoveryConstraintBuilder withCategory(String category) {
        this.constraints.add(new EntityDiscoveryCategoryMatches(category));
        return this;
    }

    public DiscoveryConstraintBuilder withBaseEntity(String baseEntity) {
        this.constraints.add(new EntityDiscoveryBaseEntityMatches(baseEntity));
        return this;
    }

    public DiscoveryConstraintBuilder withProperty(String propertyName) {
        this.constraints.add(new PropertyDiscoveryExists(propertyName));
        return this;
    }

    public DiscoveryConstraintBuilder setOperation(LogicalOperation operation) {
        this.operation = operation;
        return this;
    }

    public DiscoveryInputConstraint<EntityDefinition> build() {
        return new CompositeDiscoveryConstraint<EntityDefinition>(this.constraints, this.operation.getValue());
    }
}

