/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.ui.laf.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

public class BackButton
extends JButton {
    public static final int MAX_WIDTH = 20;
    public static final Image BACK_IMG = ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/ctxmenu/back.png", (boolean)true);
    private String _section;

    public BackButton() {
        this.setMinimumSize(new Dimension(20, 0));
        this.setMaximumSize(new Dimension(20, Integer.MAX_VALUE));
        this.setPreferredSize(this.getMinimumSize());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    BackButton.this.fireActionPerformed(new ActionEvent(this, e.getID(), null));
                }
            }
        });
    }

    public void setSection(String section) {
        this._section = section;
        this.setToolTipText(section);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color fillColor = laf.getColor("ctx-menu-back-button-bg");
        if (this.getModel().isPressed()) {
            fillColor = Colors.lighten(fillColor, -0.1f);
        } else if (this.getModel().isRollover()) {
            fillColor = Colors.lighten(fillColor, 0.1f);
        }
        g2D.setColor(fillColor);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2D.setColor(laf.getColor("ctx-menu-back-button-border"));
        g2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int margin = 2;
        int textX = 4;
        if (this.getModel().isEnabled()) {
            int imgX = (this.getWidth() - BACK_IMG.getWidth(null)) / 2;
            g2D.drawImage(BACK_IMG, imgX, 2, null);
            textX += BACK_IMG.getHeight(null) + 2;
        }
        AffineTransform transform = g2D.getTransform();
        g2D.rotate(1.5707963267948966);
        g2D.setColor(Colors.lighten(fillColor, 0.5f));
        Font font = new JLabel().getFont();
        font = font.deriveFont(1, (float)font.getSize() + 5.0f);
        g2D.setFont(font);
        g2D.drawString(this._section, textX, -4);
        g2D.setTransform(transform);
        int fadeHeight = 20;
        int startY = this.getHeight() - 20;
        int endY = this.getHeight();
        g2D.setPaint(new GradientPaint(0.0f, startY, Colors.setAlpha(fillColor, 0), 0.0f, endY, fillColor));
        g2D.fillRect(0, startY, this.getWidth(), 20);
        g2D.dispose();
    }

    @Override
    protected void paintBorder(Graphics g) {
    }
}

