/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.StringUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JLabel;

public class MultiLineLabel
extends JLabel {
    private static final JLabel _label = new JLabel();
    private String _text = "";
    private int _maxWidth = -1;
    private int _maxHeight = -1;
    private final int _maxLines;

    public MultiLineLabel() {
        this(Integer.MAX_VALUE);
    }

    public MultiLineLabel(int maxLines) {
        this._maxLines = maxLines;
    }

    public void setMaxWidth(int maxWidth) {
        this._maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this._maxHeight = maxHeight;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.wrapLabelText(this._text);
    }

    @Override
    public void setText(String text) {
        this._text = text;
        this.wrapLabelText(this._text);
    }

    public void wrapLabelText(String text) {
        Font font = this.getFont();
        if (font == null) {
            font = _label.getFont();
        }
        Insets insets = this.getInsets();
        FontMetrics fm = this.getFontMetrics(font);
        StringBuilder sb = new StringBuilder("<html><div valign=top>");
        String br = "<br>";
        Dimension size = this.getSize();
        StringUtilities.wrapTextInStringBuilder((StringBuilder)sb, (String)text, (FontMetrics)fm, (Insets)insets, (String)br, (int)(this._maxWidth > 0 ? this._maxWidth : size.width), (int)(this._maxHeight > 0 ? this._maxHeight : size.height), (int)this._maxLines);
        sb.append("</div></html>");
        super.setText(sb.toString());
    }
}

