/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class HoverAwarePanel
extends JPanel {
    private MouseAdapter _hoverListener;
    private AWTEventListener _globalHoverListener;
    private boolean _hovered = false;

    protected abstract void onHoveredChanged();

    protected abstract void onPanelClicked();

    protected boolean isHovered(boolean changeCursor) {
        if (changeCursor) {
            if (this._hovered) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
        return this._hovered;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._hoverListener = new HoverListener();
        this.addMouseListener(this._hoverListener);
        this._globalHoverListener = new GlobalHoverListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(this._globalHoverListener, 16L);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._globalHoverListener);
        this._globalHoverListener = null;
        this.removeMouseListener(this._hoverListener);
        this._hoverListener = null;
    }

    private void setHovered(boolean hovered) {
        if (hovered != this._hovered) {
            this._hovered = hovered;
            this.onHoveredChanged();
        }
    }

    private void updateHovered(MouseEvent m) {
        Component component;
        if ((m.getID() == 504 || m.getID() == 505 || m.getID() == 500) && SwingUtilities.isDescendingFrom(component = m.getComponent(), this)) {
            Point p = m.getLocationOnScreen();
            Rectangle bounds = this.getBounds();
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this);
            bounds.setLocation(location);
            this.setHovered(bounds.contains(p));
        }
    }

    private class HoverListener
    extends MouseAdapter {
        private HoverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HoverAwarePanel.this.updateHovered(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            HoverAwarePanel.this.updateHovered(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            if (source instanceof HoverAwarePanel) {
                HoverAwarePanel.this.onPanelClicked();
            }
        }
    }

    private class GlobalHoverListener
    implements AWTEventListener {
        private GlobalHoverListener() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent m = (MouseEvent)e;
                HoverAwarePanel.this.updateHovered(m);
            }
        }
    }
}

