/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Color;

public class ColorIncrement {
    private int _red;
    private int _green;
    private int _blue;

    public ColorIncrement(int red, int green, int blue) {
        this._red = red;
        this._blue = blue;
        this._green = green;
    }

    public static ColorIncrement calculate(Color from, Color to) {
        return ColorIncrement.calculate(from, to, 1);
    }

    public static ColorIncrement calculate(Color from, Color to, int intervals) {
        return new ColorIncrement((to.getRed() - from.getRed()) / intervals, (to.getGreen() - from.getGreen()) / intervals, (to.getBlue() - from.getBlue()) / intervals);
    }

    public Color increment(Color color) {
        return new Color(ColorIncrement.cap(color.getRed() + this.getRed()), ColorIncrement.cap(color.getGreen() + this.getGreen()), ColorIncrement.cap(color.getBlue() + this.getBlue()));
    }

    public Color decrement(Color color) {
        return new Color(ColorIncrement.cap(color.getRed() - this.getRed()), ColorIncrement.cap(color.getGreen() - this.getGreen()), ColorIncrement.cap(color.getBlue() - this.getBlue()));
    }

    private static int cap(double i) {
        if (i < 0.0) {
            return 0;
        }
        if (i > 255.0) {
            return 255;
        }
        return (int)i;
    }

    public int getRed() {
        return this._red;
    }

    public int getGreen() {
        return this._green;
    }

    public int getBlue() {
        return this._blue;
    }
}

