/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.ColorIncrement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class BusyBanner
extends JComponent {
    public static final int MOVE_LOOP = 0;
    public static final int MOVE_LEFT_RIGHT = 1;
    public static final int SHADING_DARK_LIGHT = 0;
    public static final int SHADING_DARK_LIGHT_DARK = 1;
    private Dot[] _dots;
    private int _dotCount = 11;
    private int _dotSize = 5;
    private Color _startColor = Color.darkGray;
    private Color _endColor = Color.lightGray;
    private Color _animationColor = new Color(200, 0, 0);
    private Timer _timer = new Timer(600, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BusyBanner.this.onTimer();
        }
    });
    private int _animatedIndex = -1;
    private boolean _animateUp = true;
    private int _movementStyle = 0;
    private int _shadingStyle = 0;

    @Override
    public void doLayout() {
        super.doLayout();
        this.createDots();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.paintDots((Graphics2D)g);
    }

    public void start() {
        this._timer.start();
    }

    public void stop() {
        this._timer.stop();
        this._animatedIndex = -1;
        this.repaint();
    }

    public void pause() {
        this._timer.stop();
    }

    private void onTimer() {
        this._animatedIndex = this.nextIndex(this._animatedIndex);
        this.repaint();
    }

    private int nextIndex(int index) {
        if (this.getMovementStyle() == 1) {
            index = this._animateUp ? ++index : --index;
            if (index < 0) {
                index = 1;
                this._animateUp = true;
            } else if (index >= this._dotCount) {
                this._animateUp = false;
                index = this._dotCount - 2;
            }
        } else if (++index >= this.getDotCount()) {
            index = 0;
        }
        return index;
    }

    private void createDots() {
        int spaceLeft = 5;
        int spaceRight = 5;
        this._dots = new Dot[this.getDotCount()];
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right - spaceLeft - spaceRight;
        double spacing = (double)width / (double)(this.getDotCount() - 1);
        int x = insets.left + spaceLeft;
        int y = (this.getHeight() - insets.top - insets.bottom) / 2 + insets.top;
        int halfDotCount = this.getShadingStyle() == 1 ? (int)Math.ceil((double)this._dotCount / 2.0) : this.getDotCount();
        Color color = this.getStartColor();
        ColorIncrement colorIncrement = ColorIncrement.calculate(this.getStartColor(), this.getEndColor(), halfDotCount);
        for (int i = 0; i < this.getDotCount(); ++i) {
            color = i < halfDotCount ? colorIncrement.increment(color) : colorIncrement.decrement(color);
            this._dots[i] = new Dot(new Point(x, y), color);
            x = (int)((double)x + spacing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDots(Graphics2D g) {
        Object oldAntiAlias = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this._dots.length; ++i) {
                this.paintDot(g, this._dots[i], this.isAnimated(i));
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAlias);
        }
    }

    private void paintDot(Graphics2D g, Dot dot, boolean animated) {
        Point p = dot.getPosition();
        Color color = dot.getColor();
        if (animated) {
            g.setColor(this.getAnimationColor());
        } else {
            g.setColor(color);
        }
        g.fillOval(p.x, p.y, this.getDotSize(), this.getDotSize());
    }

    private boolean isAnimated(int index) {
        return this._animatedIndex == index;
    }

    public int getDotCount() {
        return this._dotCount;
    }

    public void setDotCount(int dotCount) {
        this._dotCount = dotCount;
    }

    public int getDotSize() {
        return this._dotSize;
    }

    public void setDotSize(int dotSize) {
        this._dotSize = dotSize;
    }

    public Color getStartColor() {
        return this._startColor;
    }

    public void setStartColor(Color startColor) {
        this._startColor = startColor;
    }

    public Color getEndColor() {
        return this._endColor;
    }

    public void setEndColor(Color endColor) {
        this._endColor = endColor;
    }

    public int getMovementStyle() {
        return this._movementStyle;
    }

    public void setMovementStyle(int movementStyle) {
        this._movementStyle = movementStyle;
    }

    public int getShadingStyle() {
        return this._shadingStyle;
    }

    public void setShadingStyle(int shadingStyle) {
        this._shadingStyle = shadingStyle;
    }

    public Color getAnimationColor() {
        return this._animationColor;
    }

    public void setAnimationColor(Color animationColor) {
        this._animationColor = animationColor;
    }

    private class Dot {
        private Color _color;
        private Point _position;

        public Dot(Point ulCorner, Color color) {
            this._color = color;
            this._position = ulCorner;
        }

        public Color getColor() {
            return this._color;
        }

        public Point getPosition() {
            return this._position;
        }
    }
}

