/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.DefaultHubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.imex.HubSeedConfig;
import com.paterva.maltego.seeds.ui.imex.HubSeedDescriptorEntryFactory;
import com.paterva.maltego.seeds.ui.imex.HubSeedInstalledInfo;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.manager.imex.seeds.SeedConfig;
import com.paterva.maltego.transform.manager.imex.seeds.SeedImporter;
import com.paterva.maltego.transform.manager.imex.seeds.TransformSeedEntryFactory;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformImporter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class HubSeedImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List seeds = reader.readAll((EntryFactory)new TransformSeedEntryFactory(), "Graph1");
        List hubSeeds = reader.readAll((EntryFactory)new HubSeedDescriptorEntryFactory(), "Graph1");
        TransformConfig transformConfig = (TransformConfig)new TransformImporter().loadConfig(reader);
        if (transformConfig != null) {
            TransformServerInfo[] servers = transformConfig.getServers();
            TransformDescriptor[] transforms = (TransformDescriptor[])transformConfig.getAll();
            return this.createConfig(seeds, hubSeeds, servers, transforms);
        }
        return null;
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        SeedConfig seedConfig = (SeedConfig)new SeedImporter().loadPreviousConfig(configRoot);
        List<TransformSeed> seeds = seedConfig == null ? Collections.emptyList() : Arrays.asList(seedConfig.getSelected());
        List hubSeeds = new DefaultHubSeedRegistry(configRoot).loadSeeds().getSeeds();
        TransformConfig transformConfig = (TransformConfig)new TransformImporter().loadPreviousConfig(configRoot);
        if (transformConfig != null) {
            TransformServerInfo[] servers = transformConfig.getServers();
            TransformDescriptor[] transforms = (TransformDescriptor[])transformConfig.getAll();
            return this.createConfig(seeds, hubSeeds, servers, transforms);
        }
        return null;
    }

    private Config createConfig(List<TransformSeed> seeds, List<HubSeedDescriptor> hubSeeds, TransformServerInfo[] servers, TransformDescriptor[] transforms) {
        HashMap<HubSeedDescriptor, TransformSeed> seedMap = new HashMap<HubSeedDescriptor, TransformSeed>();
        for (TransformSeed seed : seeds) {
            com.paterva.maltego.licensing.mode.A licenseMode;
            HubSeedDescriptor hubSeed = null;
            String displayName = seed.getDisplayName();
            for (HubSeedDescriptor hs : hubSeeds) {
                boolean urlPresentInSeedUrls = hs.getGrantedHubSeedUrls().stream().map(s -> s.getUrl()).collect(Collectors.toList()).contains(seed.getUrl().toString());
                String hubSeedDisplayName = hs.getDisplayName();
                if (!displayName.equals(hubSeedDisplayName) || !urlPresentInSeedUrls) continue;
                hubSeed = hs;
                break;
            }
            if ((hubSeed = HubSeedImporter.checkHubSeedAllowed(licenseMode = LicenseManager.A().A(false), seed, displayName, hubSeed, true, false)) == null) continue;
            seedMap.put(hubSeed, seed);
        }
        if (seedMap.isEmpty()) {
            return null;
        }
        ArrayList<HubSeedDescriptor> selected = new ArrayList<HubSeedDescriptor>();
        HubSeedInstalledInfo installedInfo = new HubSeedInstalledInfo();
        for (HubSeedDescriptor hubSeed : seedMap.keySet()) {
            if (installedInfo.exist(hubSeed)) continue;
            selected.add(hubSeed);
        }
        return new HubSeedConfig(seedMap, selected, servers, transforms);
    }

    static HubSeedDescriptor checkHubSeedAllowed(com.paterva.maltego.licensing.mode.A licenseMode, TransformSeed seed, String name, HubSeedDescriptor hubSeed, boolean doUrlAllowedCheck1, boolean doUrlAllowedCheck2) {
        if (licenseMode.W()) {
            if (MaltegoIdProductRestrictions.isProbablyFree((com.paterva.maltego.licensing.mode.A)licenseMode) && hubSeed != null) {
                if (!hubSeed.isCustom()) {
                    HubSeeds regSeeds = HubSeedRegistry.getDefault().getSeeds(false);
                    HubSeedUrl url = null;
                    if (regSeeds.getSeed(hubSeed.getName(), url) == null) {
                        hubSeed = null;
                    }
                } else if (!MaltegoIdProductRestrictions.allowInternalHubItem((com.paterva.maltego.licensing.mode.A)licenseMode) || doUrlAllowedCheck1 && !MaltegoIdProductRestrictions.internalUrlAllowed((com.paterva.maltego.licensing.mode.A)licenseMode, (String)name) || !doUrlAllowedCheck1 && MaltegoIdProductRestrictions.isProbablyFree((com.paterva.maltego.licensing.mode.A)licenseMode)) {
                    hubSeed = null;
                }
            } else if (hubSeed == null && (doUrlAllowedCheck2 && MaltegoIdProductRestrictions.internalUrlAllowed((com.paterva.maltego.licensing.mode.A)licenseMode, (String)name) || !doUrlAllowedCheck2 && !MaltegoIdProductRestrictions.isProbablyFree((com.paterva.maltego.licensing.mode.A)licenseMode))) {
                hubSeed = HubSeedRegistry.getDefault().getHubSeed(seed);
            }
        } else if (licenseMode.Q() && hubSeed != null) {
            if (!hubSeed.isCustom()) {
                HubSeeds regSeeds = HubSeedRegistry.getDefault().getSeeds(false);
                HubSeedUrl url = null;
                if (regSeeds.getSeed(hubSeed.getName(), url) == null) {
                    hubSeed = null;
                }
            } else if (doUrlAllowedCheck1 && !A.C((com.paterva.maltego.licensing.mode.A)licenseMode, (String)name) || !doUrlAllowedCheck1 && licenseMode.Q()) {
                hubSeed = null;
            }
        } else if (hubSeed == null && (doUrlAllowedCheck2 && A.C((com.paterva.maltego.licensing.mode.A)licenseMode, (String)name) || !doUrlAllowedCheck2 && !licenseMode.Q())) {
            hubSeed = HubSeedRegistry.getDefault().getHubSeed(seed);
        }
        return hubSeed;
    }

    public int applyConfig(Config config) {
        HubSeedDescriptor[] selected;
        HubSeedConfig seedConfig = (HubSeedConfig)config;
        HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
        HubSeedSettings settings = HubSeedSettings.getDefault();
        for (HubSeedDescriptor hubSeed : selected = (HubSeedDescriptor[])seedConfig.getSelected()) {
            TransformSeed importTransformSeed = seedConfig.getTransformSeed(hubSeed);
            HubSeedUrl url = null;
            HubSeedDescriptor registrySeed = seeds.getSeed(hubSeed.getName(), url);
            boolean importSeedUrlsSameAsRegistryHub = false;
            if (registrySeed != null) {
                List registrySeedHubUrls = registrySeed.getGrantedHubSeedUrls().stream().map(s -> s.getUrl()).collect(Collectors.toList());
                List importHubSeedUrls = hubSeed.getGrantedHubSeedUrls().stream().map(hs -> hs.getUrl()).collect(Collectors.toList());
                importSeedUrlsSameAsRegistryHub = registrySeedHubUrls.containsAll(importHubSeedUrls);
            }
            if (registrySeed != null && importSeedUrlsSameAsRegistryHub) {
                if (registrySeed.isCustom()) {
                    this.updateSeed(registrySeed, hubSeed, importTransformSeed);
                    registrySeed = hubSeed;
                }
                HashSet<TransformDescriptor> transformsUpdated = new HashSet<TransformDescriptor>();
                if (settings.isInstalled(registrySeed)) {
                    transformsUpdated.addAll(this.updateInstalledTxSettings(seedConfig, registrySeed));
                } else {
                    transformsUpdated.addAll(this.updateServersAndTransforms(seedConfig, registrySeed));
                }
                this.deriveHubSettingsFromTxSettings(hubSeed, transformsUpdated);
                continue;
            }
            if (registrySeed != null && !importSeedUrlsSameAsRegistryHub) {
                this.updateSeed(registrySeed, hubSeed, importTransformSeed);
                registrySeed = hubSeed;
                settings.setInstalled(registrySeed, false);
                this.updateServersAndTransforms(seedConfig, registrySeed);
                continue;
            }
            this.updateSeed(null, hubSeed, importTransformSeed);
            registrySeed = hubSeed;
            settings.setInstalled(registrySeed, false);
            this.updateServersAndTransforms(seedConfig, registrySeed);
        }
        return selected.length;
    }

    private void deriveHubSettingsFromTxSettings(HubSeedDescriptor hubSeed, Set<TransformDescriptor> transformsUpdated) {
        DisplayDescriptorCollection seedProps;
        if (!transformsUpdated.isEmpty() && (seedProps = HubSeedSettings.getDefault().getGlobalTransformProperties(hubSeed)) != null) {
            DataSource hubSettings = HubSeedSettings.getDefault().getGlobalTransformSettings(hubSeed);
            Map<String, Object> seedSingleValueTxProps = this.getSeedPropsThatHaveSingleTxValue(seedProps, transformsUpdated);
            for (Map.Entry<String, Object> entry : seedSingleValueTxProps.entrySet()) {
                Object value;
                String propName = entry.getKey();
                DisplayDescriptor hubProperty = seedProps.get(propName);
                Object oldValue = hubSettings.getValue((PropertyDescriptor)hubProperty);
                if (oldValue != null && !Utilities.compareObjects((Object)oldValue, (Object)hubProperty.getDefaultValue()) || (value = entry.getValue()) == null) continue;
                hubSettings.setValue((PropertyDescriptor)hubProperty, value);
            }
        }
    }

    private Map<String, Object> getSeedPropsThatHaveSingleTxValue(DisplayDescriptorCollection seedProps, Set<TransformDescriptor> transformsUpdated) {
        HashSet<String> multiValueProps = new HashSet<String>();
        HashMap<String, Object> seedSingleValueTxProps = new HashMap<String, Object>();
        for (TransformDescriptor transform : transformsUpdated) {
            if (!(transform instanceof TransformDefinition)) continue;
            TransformDefinition tx = (TransformDefinition)transform;
            for (DisplayDescriptor property : tx.getProperties()) {
                String propName = property.getName();
                if (multiValueProps.contains(propName) || !seedProps.contains(propName)) continue;
                Object value = tx.getValue((PropertyDescriptor)property);
                if (!seedSingleValueTxProps.containsKey(propName)) {
                    seedSingleValueTxProps.put(propName, value);
                    continue;
                }
                Object previousValue = seedSingleValueTxProps.get(propName);
                if (Utilities.compareObjects((Object)value, previousValue)) continue;
                seedSingleValueTxProps.remove(propName);
                multiValueProps.add(propName);
            }
        }
        return seedSingleValueTxProps;
    }

    private Set<TransformDescriptor> updateServersAndTransforms(HubSeedConfig seedConfig, HubSeedDescriptor registrySeed) {
        HashSet<TransformDescriptor> txToUpdate = new HashSet<TransformDescriptor>();
        List<TransformServerInfo> importServers = this.getImportServers(seedConfig, registrySeed);
        if (!importServers.isEmpty()) {
            HashSet<String> transformsToUpdate = new HashSet<String>();
            for (TransformServerInfo importServer : importServers) {
                transformsToUpdate.addAll(this.updateServer(importServer, registrySeed));
            }
            txToUpdate.addAll(this.getTransforms(transformsToUpdate, seedConfig));
            this.updateTransforms(txToUpdate);
            HubSeedSettings.getDefault().setInstalled(registrySeed, true);
        }
        return txToUpdate;
    }

    private Set<String> updateServer(TransformServerInfo importServer, HubSeedDescriptor hubSeed) {
        HashSet<String> transforms = new HashSet<String>();
        TransformServerRegistry registry = TransformServerRegistry.getDefault();
        TransformServerInfo installedServer = registry.get(importServer.getUrl());
        if (installedServer != null) {
            for (HubSeedUrl grantedHubSeedUrl : hubSeed.getGrantedHubSeedUrls()) {
                installedServer.addSeedUrl(grantedHubSeedUrl.getUrl());
                registry.put(installedServer);
                transforms.addAll(installedServer.getTransforms());
            }
        } else {
            importServer.setDirty();
            registry.put(importServer);
            transforms.addAll(importServer.getTransforms());
        }
        return transforms;
    }

    private Set<TransformDescriptor> updateInstalledTxSettings(HubSeedConfig seedConfig, HubSeedDescriptor hubSeed) {
        TransformServerInfo[] importServers = seedConfig.getServers();
        ArrayList<TransformServerInfo> installedServers = new ArrayList<TransformServerInfo>();
        for (HubSeedUrl grantedHubSeedUrl : hubSeed.getGrantedHubSeedUrls()) {
            List<TransformServerInfo> installedServersInner = this.getInstalledServers(grantedHubSeedUrl.getUrl());
            for (TransformServerInfo transformServerInfo : installedServersInner) {
                if (installedServers.contains(transformServerInfo)) continue;
                installedServers.add(transformServerInfo);
            }
        }
        HashSet<TransformDescriptor> txToUpdate = new HashSet<TransformDescriptor>();
        for (TransformServerInfo installedServer : installedServers) {
            for (TransformServerInfo importServer : importServers) {
                if (!installedServer.equals(importServer)) continue;
                List<TransformDescriptor> importTransforms = this.getImportTransforms(seedConfig, importServer);
                for (TransformDescriptor importTransform : importTransforms) {
                    for (String transformName : installedServer.getTransforms()) {
                        if (!transformName.equals(importTransform.getName())) continue;
                        txToUpdate.add(importTransform);
                    }
                }
            }
        }
        this.updateTransforms(txToUpdate);
        return txToUpdate;
    }

    private void updateTransforms(Set<TransformDescriptor> txToUpdate) {
        if (!txToUpdate.isEmpty()) {
            TransformDescriptor[] transforms = txToUpdate.toArray(new TransformDescriptor[txToUpdate.size()]);
            TransformImporter transformImporter = new TransformImporter();
            transformImporter.updateTransforms(transforms);
        }
    }

    private void updateSeed(HubSeedDescriptor registrySeed, HubSeedDescriptor hubSeed, TransformSeed importTransformSeed) {
        HubSeedDescriptor sameUrlSeed;
        HubSeedRegistry registry = HubSeedRegistry.getDefault();
        if (registrySeed != null) {
            registry.removeSeed(registrySeed, true);
        }
        if ((sameUrlSeed = registry.getHubSeed(hubSeed.getGrantedHubSeedUrls())) == null) {
            registry.addSeed(hubSeed);
        }
        HubSeedSettings settings = HubSeedSettings.getDefault();
        DataSource dataSource = settings.getGlobalTransformSettings(hubSeed);
        DisplayDescriptorCollection globalTxProps = settings.getGlobalTransformProperties(hubSeed);
        if (globalTxProps != null) {
            for (DisplayDescriptor property : globalTxProps) {
                Object value = importTransformSeed.getGlobalTxSettings().getValue((PropertyDescriptor)property);
                if (value == null || !property.getTypeDescriptor().getType().equals(value.getClass())) continue;
                dataSource.setValue((PropertyDescriptor)property, value);
            }
        }
    }

    private List<TransformServerInfo> getImportServers(HubSeedConfig seedConfig, HubSeedDescriptor hubSeed) {
        ArrayList<TransformServerInfo> servers = new ArrayList<TransformServerInfo>();
        List hubSeedUrls = hubSeed.getGrantedHubSeedUrls().stream().map(s -> s.getUrl()).collect(Collectors.toList());
        for (TransformServerInfo server : seedConfig.getServers()) {
            ArrayList intersectedUrls = new ArrayList(hubSeedUrls);
            intersectedUrls.retainAll(server.getSeedUrls());
            if (intersectedUrls.isEmpty()) continue;
            servers.add(server);
        }
        return servers;
    }

    private List<TransformServerInfo> getInstalledServers(String seedUrl) {
        ArrayList<TransformServerInfo> servers = new ArrayList<TransformServerInfo>();
        for (TransformServerInfo server : TransformServerRegistry.getDefault().getAll()) {
            if (!server.getSeedUrls().contains(seedUrl)) continue;
            servers.add(server);
        }
        return servers;
    }

    private List<TransformDescriptor> getImportTransforms(HubSeedConfig seedConfig, TransformServerInfo importServer) {
        Set transformNames = importServer.getTransforms();
        List<TransformDescriptor> transforms = this.getTransforms(transformNames, seedConfig);
        return transforms;
    }

    private List<TransformDescriptor> getTransforms(Set<String> transformNames, HubSeedConfig seedConfig) {
        ArrayList<TransformDescriptor> transforms = new ArrayList<TransformDescriptor>();
        for (String transformName : transformNames) {
            for (TransformDescriptor transform : seedConfig.getTransforms()) {
                if (!transformName.equals(transform.getName())) continue;
                transforms.add(transform);
            }
        }
        return transforms;
    }
}

