/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3;

import javax.swing.JButton;
import javax.swing.Timer;

public class JButtonAutoAccept
extends JButton {
    private static final int TICK_INTERVAL_MS = 1000;
    private Timer timer;
    private int timeRemainingMs;
    private boolean timedOut = false;

    public JButtonAutoAccept(String text, Integer timeOutSec) {
        if (timeOutSec == null || timeOutSec <= 0) {
            this.setText(text);
        } else {
            this.timeRemainingMs = timeOutSec * 1000;
            this.setText(JButtonAutoAccept.getButtonText(text, this.timeRemainingMs));
            this.timer = new Timer(1000, e -> {
                this.timeRemainingMs -= 1000;
                this.setText(JButtonAutoAccept.getButtonText(text, this.timeRemainingMs));
                if (this.timeRemainingMs <= 0) {
                    this.timedOut = true;
                    this.doClick();
                    this.timer.stop();
                }
            });
            this.timer.start();
            this.timer.setRepeats(true);
        }
    }

    public boolean getTimedOut() {
        return this.timedOut;
    }

    private static String getButtonText(String text, Integer timeOutMs) {
        if (timeOutMs < 1000) {
            return String.format("%s (%s ms)", text, timeOutMs);
        }
        return String.format("%s (%s sec)", text, timeOutMs / 1000);
    }
}

