/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.impl;

import com.paterva.maltego.util.StringUtilities;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class ExtensionStringUtil {
    private static final Map<String, Integer> keyUsageFlags = new HashMap<String, Integer>(){
        {
            this.put("digital_signature", 128);
            this.put("non_repudiation", 64);
            this.put("key_encipherment", 32);
            this.put("data_encipherment", 16);
            this.put("key_agreement", 8);
            this.put("key_cert_sign", 4);
            this.put("crl_sign", 2);
            this.put("encipher_only", 1);
            this.put("decipher_only", 32768);
        }
    };
    private static final Map<Integer, String> generalNameTags = new HashMap<Integer, String>(){
        {
            this.put(0, "Other Name");
            this.put(1, "RFC822 Name");
            this.put(2, "DNS Name");
            this.put(3, "X400 Address");
            this.put(4, "Directory Name");
            this.put(5, "EDI Party Name");
            this.put(6, "URI");
            this.put(7, "IP");
            this.put(8, "Registered ID");
        }
    };

    public static String toString(Extensions extensions) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<Map<String, Object>> extensionList = ExtensionStringUtil.getExtensionList(extensions);
        ExtensionStringUtil.appendList(sb, extensionList, 0);
        return sb.toString();
    }

    private static void append(StringBuilder sb, Object object, int depth) {
        if (object instanceof List) {
            ExtensionStringUtil.appendList(sb, (List)object, depth);
        } else if (object instanceof Map) {
            ExtensionStringUtil.appendMap(sb, (Map)object, depth);
        } else {
            ExtensionStringUtil.indent(sb, depth).append(object == null ? "<none>" : object.toString()).append(Strings.lineSeparator());
        }
    }

    private static void appendList(StringBuilder sb, List list, int depth) {
        for (Object object : list) {
            ExtensionStringUtil.append(sb, object, depth);
        }
    }

    private static void appendMap(StringBuilder sb, Map<String, Object> map, int depth) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ExtensionStringUtil.indent(sb, depth).append(key);
            if (!key.isEmpty()) {
                sb.append(": ");
            }
            if (value instanceof List || value instanceof Map) {
                sb.append(Strings.lineSeparator());
                ExtensionStringUtil.append(sb, value, depth + 1);
                continue;
            }
            sb.append(ExtensionStringUtil.plainObjectToString(value)).append(Strings.lineSeparator());
        }
    }

    private static String plainObjectToString(Object object) {
        if (object instanceof byte[]) {
            String hex = Hex.toHexString((byte[])((byte[])object)).toUpperCase();
            return StringUtilities.insertStringPeriodically((String)hex, (String)" ", (int)2);
        }
        return object == null ? "<none>" : object.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("   ");
        }
        return sb;
    }

    private static List<Map<String, Object>> getExtensionList(Extensions exts) throws IOException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (ASN1ObjectIdentifier oid : exts.getCriticalExtensionOIDs()) {
            ret.add(ExtensionStringUtil.makeExtensionMap(exts, oid, true));
        }
        for (ASN1ObjectIdentifier oid : exts.getNonCriticalExtensionOIDs()) {
            ret.add(ExtensionStringUtil.makeExtensionMap(exts, oid, false));
        }
        return ret;
    }

    private static Map<String, Object> makeExtensionMap(Extensions exts, ASN1ObjectIdentifier oid, boolean critical) throws IOException {
        Extension ext = exts.getExtension(oid);
        if (ext != null) {
            byte[] extensionData = ext.getExtnValue().getOctets();
            ASN1Object asn1Value = ExtensionStringUtil.binaryToASN1Object(oid, extensionData);
            LinkedHashMap<String, Object> retInner = new LinkedHashMap<String, Object>();
            retInner.put("ObjectID", oid.getId());
            retInner.put("Critical", critical);
            retInner.put("Value", ExtensionStringUtil.asn1ObjToObj((ASN1Encodable)asn1Value));
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put(asn1Value.getClass().getSimpleName(), retInner);
            ret.put("", "");
            return ret;
        }
        return null;
    }

    private static ASN1Object binaryToASN1Object(ASN1ObjectIdentifier oid, byte[] data) throws IOException {
        if (oid.equals((ASN1Primitive)Extension.subjectAlternativeName) || oid.equals((ASN1Primitive)Extension.issuerAlternativeName)) {
            return GeneralNames.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.authorityKeyIdentifier)) {
            return AuthorityKeyIdentifier.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.subjectKeyIdentifier)) {
            return SubjectKeyIdentifier.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.basicConstraints)) {
            return BasicConstraints.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)Extension.keyUsage)) {
            DERBitString bs = (DERBitString)ASN1Primitive.fromByteArray((byte[])data);
            return KeyUsage.getInstance((Object)bs);
        }
        if (oid.equals((ASN1Primitive)Extension.extendedKeyUsage)) {
            return ExtendedKeyUsage.getInstance((Object)data);
        }
        if (oid.equals((ASN1Primitive)MiscObjectIdentifiers.netscapeCertComment)) {
            try {
                return ASN1Primitive.fromByteArray((byte[])data);
            }
            catch (EOFException e) {
                return new DERIA5String(new String(data, Charset.forName("US-ASCII")));
            }
        }
        if (oid.equals((ASN1Primitive)Extension.cRLNumber)) {
            return CRLNumber.getInstance((Object)data);
        }
        try {
            return DERUTF8String.getInstance((Object)data);
        }
        catch (Exception e) {
            return new DERUTF8String(new String(data, Charset.forName("US-ASCII")));
        }
    }

    private static Object asn1ObjToObj(ASN1Encodable asn1Prim) throws IOException {
        if (asn1Prim instanceof GeneralNames) {
            return ExtensionStringUtil.generalNamesToMap((GeneralNames)asn1Prim);
        }
        if (asn1Prim instanceof ASN1ObjectIdentifier) {
            return ((ASN1ObjectIdentifier)asn1Prim).getId();
        }
        if (asn1Prim instanceof AuthorityKeyIdentifier) {
            return ExtensionStringUtil.authorityKeyIdToMap((AuthorityKeyIdentifier)asn1Prim);
        }
        if (asn1Prim instanceof BasicConstraints) {
            return ExtensionStringUtil.basicConstraintsToMap((BasicConstraints)asn1Prim);
        }
        if (asn1Prim instanceof CRLNumber) {
            CRLNumber crlNumber = (CRLNumber)asn1Prim;
            return crlNumber.getCRLNumber();
        }
        if (asn1Prim instanceof SubjectKeyIdentifier) {
            SubjectKeyIdentifier ski = (SubjectKeyIdentifier)asn1Prim;
            return ski.getKeyIdentifier();
        }
        if (asn1Prim instanceof ExtendedKeyUsage) {
            return ExtensionStringUtil.extKeyUsageToList((ExtendedKeyUsage)asn1Prim);
        }
        if (asn1Prim instanceof KeyPurposeId) {
            KeyPurposeId kpi = (KeyPurposeId)asn1Prim;
            return kpi.getId();
        }
        if (asn1Prim instanceof KeyUsage) {
            KeyUsage ku = (KeyUsage)asn1Prim;
            return ExtensionStringUtil.keyUsageToList(ku);
        }
        if (asn1Prim instanceof DERBitString) {
            DERBitString bitString = (DERBitString)asn1Prim;
            return bitString.getString();
        }
        if (asn1Prim instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedObj = (ASN1TaggedObject)asn1Prim;
            return ExtensionStringUtil.asn1ObjToObj((ASN1Encodable)taggedObj.getObject());
        }
        if (asn1Prim instanceof ASN1Sequence) {
            return ExtensionStringUtil.asn1SeqToList((ASN1Sequence)asn1Prim);
        }
        if (asn1Prim instanceof ASN1String) {
            ASN1String str = (ASN1String)asn1Prim;
            return str.getString();
        }
        if (asn1Prim instanceof ASN1OctetString) {
            ASN1OctetString str = (ASN1OctetString)asn1Prim;
            return new String(str.getOctets(), "UTF-8");
        }
        if (asn1Prim instanceof X500Name) {
            X500Name name = (X500Name)asn1Prim;
            return name.toString();
        }
        return asn1Prim.toASN1Primitive().getEncoded();
    }

    private static Map<String, List<String>> generalNamesToMap(GeneralNames names) throws IOException {
        if (names != null) {
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            for (GeneralName generalName : names.getNames()) {
                String name;
                String type = generalNameTags.get(generalName.getTagNo());
                if (ret.get(type) == null) {
                    ret.put(type, new ArrayList());
                }
                switch (generalName.getTagNo()) {
                    case 7: {
                        name = ExtensionStringUtil.octetStringToIpString((ASN1OctetString)generalName.getName());
                        break;
                    }
                    default: {
                        name = ExtensionStringUtil.asn1ObjToObj(generalName.getName()).toString();
                    }
                }
                ((List)ret.get(type)).add(name);
            }
            return ret;
        }
        return null;
    }

    private static Map<String, Object> authorityKeyIdToMap(AuthorityKeyIdentifier akid) throws IOException {
        BigInteger serial = akid.getAuthorityCertSerialNumber();
        String serialStr = null;
        if (serial != null) {
            serialStr = Hex.toHexString((byte[])serial.toByteArray()).toUpperCase();
            serialStr = StringUtilities.insertStringPeriodically((String)serialStr, (String)" ", (int)2);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("Issuer", ExtensionStringUtil.generalNamesToMap(akid.getAuthorityCertIssuer()));
        ret.put("Serial Number", serialStr);
        ret.put("Key Identifier", akid.getKeyIdentifier());
        return ret;
    }

    private static Map<String, Object> basicConstraintsToMap(BasicConstraints bc) {
        BigInteger pathLen = bc.getPathLenConstraint();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("CA", bc.isCA());
        ret.put("Path Length Constraint", pathLen);
        return ret;
    }

    private static List<Object> extKeyUsageToList(ExtendedKeyUsage eku) throws IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (KeyPurposeId kpid : eku.getUsages()) {
            ret.add(ExtensionStringUtil.asn1ObjToObj((ASN1Encodable)kpid));
        }
        return ret;
    }

    private static List<String> keyUsageToList(KeyUsage ku) {
        HashSet<String> ret = new HashSet<String>();
        for (String key : keyUsageFlags.keySet()) {
            if (!ku.hasUsages(keyUsageFlags.get(key).intValue())) continue;
            ret.add(key);
        }
        return new ArrayList<String>(ret);
    }

    private static List<Object> asn1SeqToList(ASN1Sequence seq) throws IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < seq.size(); ++i) {
            ret.add(ExtensionStringUtil.asn1ObjToObj(seq.getObjectAt(i)));
        }
        return ret;
    }

    public static String octetStringToIpString(ASN1OctetString ip) throws UnknownHostException {
        return InetAddress.getByAddress(ip.getOctets()).toString().split("/")[1];
    }
}

