/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.util.repository.AbstractRepository;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.openide.util.Lookup;

public abstract class CertificateRepository
extends AbstractRepository {
    private static CertificateRepository _default;

    public static synchronized CertificateRepository getDefault() {
        if (_default == null && (_default = (CertificateRepository)((Object)Lookup.getDefault().lookup(CertificateRepository.class))) == null) {
            throw new IllegalStateException("Certificate Repository not found.");
        }
        return _default;
    }

    public abstract CertificateDefinition get(X509Certificate var1);

    public abstract Collection<? extends X509Certificate> getAllDisplay();

    public abstract void update(X509Certificate var1, boolean var2, String var3);

    public abstract boolean remove(X509Certificate var1);

    public abstract KeyStore getKeyStore(boolean var1) throws GeneralSecurityException, IOException;

    public abstract boolean isCaValid(X509Certificate var1);

    public abstract boolean containsCa(X509Certificate var1);

    public abstract boolean containsCa(X509Certificate var1, boolean var2);

    public abstract boolean contains(X509Certificate var1, boolean var2);

    public abstract boolean contains(X509Certificate var1);

    public boolean urlMatchesCertHostnames(X509Certificate cert, URL url) {
        List<String> hostnames;
        boolean matches = false;
        CertificateDefinition certDef = this.get(cert);
        if (certDef != null && (hostnames = certDef.getHostnames()) != null) {
            matches = CertificateUtils.urlMatchesHostnames(hostnames, url);
        }
        return matches;
    }
}

