/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.IdentityProvider;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.api.AsyncTransformRunner;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public abstract class AbstractTransform
extends AsyncTransformRunner {
    private final TransformRunContext ctx;
    private final MatchingRuleUpdater matchingRuleUpdater;
    private boolean canceled = false;

    public AbstractTransform(TransformRunContext ctx, MatchingRuleUpdater matchingRuleUpdater) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)matchingRuleUpdater, (String)"matchingRuleUpdater");
        this.ctx = ctx;
        this.matchingRuleUpdater = matchingRuleUpdater;
    }

    protected abstract void doTransform() throws Exception;

    public TransformRunContext getContext() {
        return this.ctx;
    }

    public MatchingRuleUpdater getMatchingRuleUpdater() {
        return this.matchingRuleUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTransform() throws Exception {
        TransformDefinition transform = this.ctx.getTransform();
        TransformCallback cb = this.ctx.getCallback();
        try {
            this.doTransform();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            int entityCount = this.ctx.getOutputEntityCount();
            String msg = "Transform " + transform.getDisplayName() + " returned with " + entityCount + " entities";
            cb.resultReceived(TransformResult.info(msg, 100));
            msg = "Transform " + transform.getDisplayName() + " done";
            cb.resultReceived(TransformResult.complete(msg));
        }
    }

    public synchronized void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResults(Map<MaltegoEntity, List<MaltegoEntity>> inputToOutputEntities, Map<MaltegoLink, LinkEntityIDs> links, int progress) throws Exception {
        Args.notNull(inputToOutputEntities, (String)"inputToOutputEntities");
        Args.notNull(links, (String)"links");
        if (!inputToOutputEntities.isEmpty()) {
            TransformDefinition transformDefinition = this.ctx.getTransform();
            synchronized (transformDefinition) {
                this.matchingRuleUpdater.updateMatchingRule(this.ctx, inputToOutputEntities.keySet());
                for (Map.Entry<MaltegoEntity, List<MaltegoEntity>> entry2 : inputToOutputEntities.entrySet()) {
                    List<MaltegoEntity> entities = entry2.getValue();
                    this.matchingRuleUpdater.updateMatchingRule(this.ctx, entities);
                }
            }
            HashSet added = new HashSet();
            int entityCount = 0;
            GraphID resultGraphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
            GraphStoreWriter.addEntities((GraphID)resultGraphID, inputToOutputEntities.keySet());
            for (Map.Entry entry2 : inputToOutputEntities.entrySet()) {
                ArrayList entities = new ArrayList((Collection)entry2.getValue());
                entities.removeAll(added);
                entityCount += entities.size();
                GraphStoreWriter.addEntities((GraphID)resultGraphID, entities);
                added.addAll(entities);
            }
            GraphStoreWriter.addLinks((GraphID)resultGraphID, links);
            Map<EntityID, List<EntityID>> entityIDs = inputToOutputEntities.entrySet().stream().collect(Collectors.toMap(entry -> (EntityID)((MaltegoEntity)entry.getKey()).getID(), entry -> ((List)entry.getValue()).stream().map(IdentityProvider::getID).collect(Collectors.toList())));
            TransformResult transformResult = TransformResult.progress("", progress, resultGraphID, entityCount, false, entityIDs);
            this.ctx.getCallback().resultReceived(transformResult);
        }
    }

    protected void updateProgress(int progress) {
        this.ctx.getCallback().resultReceived(TransformResult.progress(progress));
    }

    protected Map<MaltegoLink, LinkEntityIDs> createGenericLinks(List<LinkEntityIDs> links) {
        Args.notNull(links, (String)"links");
        HashMap<MaltegoLink, LinkEntityIDs> createdLinks = new HashMap<MaltegoLink, LinkEntityIDs>();
        for (LinkEntityIDs linkIDs : links) {
            MaltegoLink maltegoLink = this.ctx.getLinkFactory().createInstance(MaltegoLinkSpec.getTransformSpec(), true);
            TransformDefinition transform = this.ctx.getTransform();
            PropertyDescriptorCollection properties = maltegoLink.getProperties();
            maltegoLink.setValue(properties.get("maltego.link.transform.name"), (Object)transform.getName());
            maltegoLink.setValue(properties.get("maltego.link.transform.display-name"), (Object)transform.getDisplayName());
            maltegoLink.setValue(properties.get("maltego.link.transform.version"), (Object)transform.getVersion());
            maltegoLink.setValue(properties.get("maltego.link.transform.run-date"), (Object)new DateTime());
            createdLinks.put(maltegoLink, linkIDs);
        }
        return createdLinks;
    }

    protected void warn(String msg) {
        Args.notNull((Object)msg, (String)"msg");
        TransformResult result = TransformResult.warning(msg);
        this.getContext().getCallback().resultReceived(result);
    }
}

