/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.imgfactory.serialization.CachedImage;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ImageCacheFileEntry
extends Entry<CachedImage> {
    private static final Logger LOG = Logger.getLogger(ImageCacheFileEntry.class.getName());
    static final String DefaultFolder = "Cache/Images";
    public static final String Type = "png";

    public ImageCacheFileEntry(CachedImage data) {
        super((Object)data, DefaultFolder, data.getCacheName() + "_" + Integer.toString(data.getId()) + "." + Type);
    }

    public ImageCacheFileEntry(String path) {
        super(path);
    }

    protected CachedImage read(InputStream is) throws IOException {
        String type = this.getTypeName();
        Matcher matcher = Pattern.compile("^(.*)_(\\d+)$").matcher(type);
        if (matcher.matches() && matcher.groupCount() == 2) {
            try {
                String cacheName = matcher.group(1);
                int id = Integer.parseInt(matcher.group(2));
                BufferedImage img = ImageIO.read(is);
                if (img != null) {
                    CachedImage image = new CachedImage(cacheName, id, img);
                    return image;
                }
                LOG.log(Level.SEVERE, "Failed to read image from graph cache: {0}, {1}, {2}", new Object[]{type, cacheName, id});
            }
            catch (NumberFormatException ex) {
                LOG.warning("Could not extract ID from cache file name.");
            }
        }
        return null;
    }

    protected void write(CachedImage data, OutputStream os) throws IOException {
        ImageIO.write((RenderedImage)ImageUtils.createBufferedImage((Image)data.getImage()), Type, os);
    }
}

