/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ui.IconManager;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListDataListener;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class IconSelectorPanel
extends JPanel {
    public static final String PROP_SELECTED_VALUE = "selectedValue";
    private static final Color ICON_LIST_BACKGROUND = UIManager.getLookAndFeelDefaults().getColor("7-white");
    private final JTabbedPane _tabbedPane = new JTabbedPane();
    private final Map<String, JList> _lists = new HashMap<String, JList>();
    private final JLabel _nameLabel = new LabelWithBackground("Name");
    private final JTextField _nameField = new JTextField();
    private final JButton _manageButton = new JButton("Manage");
    private IconSize _iconSize = IconSize.MASSIVE;
    private IconRegistry _iconRegistry;

    public IconSelectorPanel() {
        this._manageButton.addActionListener(__ -> {
            Optional icon = IconManager.getDefault().show(this.getSelectedIcon());
            try {
                WindowUtil.showWaitCursor();
                RegistryIcon selected = this.getSelectedIcon();
                this.updateIcons();
                this.setSelectedIcon(icon.orElse(selected));
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._nameField.setEditable(false);
        this._nameField.setColumns(30);
        JPanel namePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        namePanel.add((Component)this._nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        namePanel.add((Component)this._nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        namePanel.add((Component)new JPanel(), gridBagConstraints);
        JPanel eastPanel = new JPanel(new FlowLayout(4));
        eastPanel.add(this._manageButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)namePanel, "Center");
        southPanel.add((Component)eastPanel, "East");
        southPanel.setBorder(new MatteBorder(1, 0, 0, 0, UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        JPanel tabPanel = new JPanel(new BorderLayout());
        tabPanel.add((Component)this._tabbedPane, "Center");
        tabPanel.add((Component)southPanel, "South");
        this.add((Component)tabPanel, "Center");
        this.setPreferredSize(new Dimension(600, 450));
    }

    public void setIconRegistry(IconRegistry iconRegistry) {
        this._iconRegistry = iconRegistry;
        this.updateIcons();
    }

    private String getSelectedCategory() {
        String category = null;
        int index = this._tabbedPane.getSelectedIndex();
        if (index >= 0 && index < this._tabbedPane.getTabCount()) {
            category = this._tabbedPane.getTitleAt(index);
        }
        return category;
    }

    public void setSelectedCategory(String category) {
        int index = this.getTabIndex(category);
        if (index != -1) {
            this._tabbedPane.setSelectedIndex(index);
        }
    }

    private void addResourceView(String category, List<ListIcon> icons) {
        ArrayListModel model = new ArrayListModel(icons.toArray(new ListIcon[icons.size()]));
        JList<Object> view = new JList<Object>(model);
        view.setCellRenderer(new IconListCellRenderer());
        view.setSelectionMode(0);
        view.setLayoutOrientation(2);
        view.setVisibleRowCount(-1);
        view.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                RegistryIcon icon = this.getSelectedIcon();
                this._nameField.setText(icon == null ? "" : icon.getName());
            }
        });
        this._lists.put(category, view);
        JScrollPane pane = new JScrollPane(view, 20, 31);
        pane.setBackground(new JPanel().getBackground());
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), pane.getBorder()));
        this._tabbedPane.add(category, pane);
    }

    protected void setSelectedIcon(RegistryIcon icon) {
        Optional fallbackIcon;
        if (icon != null && !this._iconRegistry.existsCaseInsensitive(icon.getCategory(), icon.getName())) {
            icon = null;
        }
        if (icon == null && (fallbackIcon = this._iconRegistry.findRegistryIcon(new VirtualIcon("General", "Phrase"))).isPresent()) {
            icon = (RegistryIcon)fallbackIcon.get();
        }
        if (icon != null) {
            String category = icon.getCategory();
            this.setSelectedCategory(category);
            JList list = this._lists.get(category);
            if (list != null) {
                list.setSelectedValue(new ListIcon(icon), false);
            }
        }
    }

    private int getTabIndex(String title) {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            if (!this._tabbedPane.getTitleAt(i).equalsIgnoreCase(title)) continue;
            return i;
        }
        return -1;
    }

    protected RegistryIcon getSelectedIcon() {
        int selectedTabIndex = this._tabbedPane.getSelectedIndex();
        if (selectedTabIndex >= 0) {
            String category = this.getSelectedCategory();
            JList list = this._lists.get(category);
            ListIcon listIcon = (ListIcon)list.getSelectedValue();
            return listIcon == null ? null : listIcon.getIcon();
        }
        return null;
    }

    public IconSize getIconSize() {
        return this._iconSize;
    }

    public void setIconSize(IconSize iconSize) {
        this._iconSize = iconSize;
        for (JList list : this._lists.values()) {
            list.setFixedCellHeight(iconSize.getSize() + 5);
            list.setFixedCellWidth(iconSize.getSize() + 5);
        }
    }

    private void updateIcons() {
        this._lists.clear();
        this._tabbedPane.removeAll();
        this._iconRegistry.getSortedCategories().forEach(category -> {
            List<ListIcon> icons = this._iconRegistry.getIcons(category).stream().map(ListIcon::new).collect(Collectors.toList());
            this.addResourceView((String)category, icons);
        });
    }

    private static class ListImageCallback
    implements ImageCallback {
        private final ListIcon icon;
        private final JList list;

        public ListImageCallback(ListIcon icon, JList list) {
            this.icon = icon;
            this.list = list;
        }

        public void imageReady(Image image) {
            this.icon.setImage(image);
            this.list.repaint();
        }

        public void imageFailed(Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class ListIcon {
        private final RegistryIcon icon;
        private Image image;

        public ListIcon(RegistryIcon icon) {
            this.icon = icon;
        }

        public RegistryIcon getIcon() {
            return this.icon;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public String toString() {
            return this.icon.getName();
        }

        public int hashCode() {
            return 581 + Objects.hashCode(this.icon);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ListIcon other = (ListIcon)obj;
            return Objects.equals(this.icon, other.icon);
        }
    }

    private static class ArrayListModel
    implements ListModel {
        private final ListIcon[] _data;

        public ArrayListModel(ListIcon[] data) {
            this._data = data;
        }

        public ListIcon[] getData() {
            return this._data;
        }

        @Override
        public int getSize() {
            return this._data.length;
        }

        public Object getElementAt(int index) {
            return this._data[index];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private class IconListCellRenderer
    extends DefaultListCellRenderer {
        private IconListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setBackground(ICON_LIST_BACKGROUND);
            }
            this.setText("");
            if (value != null) {
                ListIcon icon = (ListIcon)value;
                Image image = icon.getImage();
                if (image == null) {
                    Image emptyImage = this.loadEmptyImage();
                    icon.setImage(emptyImage);
                    IconSelectorPanel.this._iconRegistry.loadImage(icon.getIcon(), IconSelectorPanel.this.getIconSize(), (ImageCallback)new ListImageCallback(icon, list));
                }
                this.setIcon(new ImageIcon(icon.getImage()));
            } else {
                Image emptyImage = this.loadEmptyImage();
                this.setIcon(new ImageIcon(emptyImage));
            }
            return c;
        }

        private Image loadEmptyImage() {
            return ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/EmptyImage" + IconSelectorPanel.this._iconSize.getSize() + ".png"));
        }
    }
}

