/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.imex.MappingEntryFactory;
import com.paterva.maltego.graph.table.ui.imex.MappingWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MappingImporter {
    public List<TabularGraph> read(MaltegoArchiveReader reader) throws IOException {
        List wrappers = reader.readAll((EntryFactory)new MappingEntryFactory(), "Graph1");
        if (wrappers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<TabularGraph> mappings = this.getMappings(wrappers);
        return mappings;
    }

    public int apply(Collection<TabularGraph> mappings) {
        MappingRegistry repo = MappingRegistry.getDefault();
        int count = 0;
        for (TabularGraph mapping : mappings) {
            String name = mapping.getName();
            TabularGraph oldMapping = repo.get(name);
            if (oldMapping != null) {
                repo.remove(name);
            }
            repo.put(mapping);
            ++count;
        }
        return count;
    }

    private List<TabularGraph> getMappings(List<MappingWrapper> wrappers) {
        ArrayList<TabularGraph> mappings = new ArrayList<TabularGraph>();
        for (MappingWrapper wrapper : wrappers) {
            TabularGraph mapping = wrapper.getMapping();
            mappings.add(mapping);
        }
        return mappings;
    }
}

