/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputEntry;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputWrapper;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputsConfig;
import com.paterva.maltego.tx.inputs.global.ui.imex.SelectableGlobalInput;
import com.paterva.maltego.tx.inputs.global.ui.imex.Util;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GlobalInputsExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        Collection inputs = GlobalTransformInputsRepository.getDefault().getAll();
        if (!inputs.isEmpty()) {
            return new GlobalInputsConfig(Util.createSelectables(inputs));
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        GlobalInputsConfig inputConfig = (GlobalInputsConfig)config;
        ArrayList<String> names = new ArrayList<String>();
        for (SelectableGlobalInput selectable : inputConfig.getSelectedGlobalInputs()) {
            if (!selectable.isSelected()) continue;
            GlobalTransformInput input = selectable.getGlobalInput();
            String fileName = this.getFileName(input, names);
            writer.write((Entry)new GlobalInputEntry(new GlobalInputWrapper(fileName, input)));
        }
        return names.size();
    }

    private String getFileName(GlobalTransformInput input, List<String> names) {
        String name = input.getDescriptor().getName();
        String fileName = FileUtilities.replaceIllegalChars((String)name);
        fileName = StringUtilities.createUniqueString(names, (String)fileName);
        names.add(fileName);
        return fileName;
    }
}

