/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.serializer.TransformDefinitionStub;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorStub;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsStub;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformDefinitionSerializer {
    public TransformDefinition read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDefinitionStub stub = (TransformDefinitionStub)serializer.read(TransformDefinitionStub.class, stream);
        return this.translate(stub);
    }

    private TransformDefinition translate(TransformDefinitionStub stub) throws XmlSerializationException {
        TransformDescriptor descriptor = TransformDescriptorSerializer.translate(stub.getDescriptor());
        TransformSettings settings = TransformSettingsSerializer.translate(stub.getSettings());
        return new TransformDefinition(descriptor, settings);
    }

    public void write(TransformDefinition definition, OutputStream stream, boolean isExport) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDefinitionStub stub = this.translate(definition, isExport);
        serializer.write((Object)stub, stream);
    }

    private TransformDefinitionStub translate(TransformDefinition definition, boolean isExport) throws XmlSerializationException {
        TransformDescriptorStub descriptorStub = TransformDescriptorSerializer.translate((TransformDescriptor)definition);
        TransformSettingsStub settingsStub = TransformSettingsSerializer.translate((TransformSettings)definition, (Iterable<DisplayDescriptor>)definition.getProperties(), isExport);
        TransformDefinitionStub definitionStub = new TransformDefinitionStub();
        definitionStub.setDescriptor(descriptorStub);
        definitionStub.setSettings(settingsStub);
        return definitionStub;
    }
}

