/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.RTableCell;
import org.lobobrowser.html.style.HtmlLength;

class VirtualCell {
    private final RTableCell actualCell;
    private final boolean isTopLeft;
    private int column;
    private int row;

    public VirtualCell(RTableCell cell, boolean isTopLeft) {
        this.actualCell = cell;
        this.isTopLeft = isTopLeft;
    }

    public boolean isTopLeft() {
        return this.isTopLeft;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public RTableCell getActualCell() {
        return this.actualCell;
    }

    public HtmlLength getHeightLength() {
        HtmlLength length;
        RTableCell cell = this.actualCell;
        String heightText = cell.getHeightText();
        try {
            length = heightText == null ? null : new HtmlLength(heightText);
        }
        catch (Exception err) {
            length = null;
        }
        if (length != null) {
            length.divideBy(cell.getRowSpan());
        }
        return length;
    }

    public HtmlLength getWidthLength() {
        HtmlLength length;
        RTableCell cell = this.actualCell;
        String widthText = cell.getWidthText();
        try {
            length = widthText == null ? null : new HtmlLength(widthText);
        }
        catch (Exception err) {
            length = null;
        }
        if (length != null) {
            length.divideBy(cell.getColSpan());
        }
        return length;
    }
}

