/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUserData;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.ui.fonts.FontFallbackStringPainter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import yguard.A.I.K;
import yguard.A.J.BA;
import yguard.A.J.X;

public class NodeLabelUtils {
    private static final boolean DRAW_ENTITY_SELECTIONS_SQUARE = true;

    public static int getBookmark(X label) {
        return NodeLabelUtils.getUserData(label).getBookmark();
    }

    public static void setBookmark(X label, int bookmark) {
        NodeLabelUtils.getUserData(label).setBookmark(bookmark);
    }

    public static boolean isHover(X label) {
        return NodeLabelUtils.getUserData(label).isHover();
    }

    public static void setHover(X label, boolean hover) {
        NodeLabelUtils.getUserData(label).setHover(hover);
    }

    private static NodeLabelUserData getUserData(X label) {
        NodeLabelUserData bookmarkLabelUserData;
        Object userData = label.getUserData();
        if (userData instanceof NodeLabelUserData) {
            bookmarkLabelUserData = (NodeLabelUserData)userData;
        } else {
            bookmarkLabelUserData = new NodeLabelUserData();
            label.setUserData((Object)bookmarkLabelUserData);
        }
        return bookmarkLabelUserData;
    }

    public static void paintLabelBackground(BA nr, Graphics2D g2D, Rectangle2D rect, double strokeWidth) {
        double offset = strokeWidth / 2.0;
        double doubleOffset = offset * 2.0;
        rect.setRect(rect.getX() - offset, rect.getY() - offset, rect.getWidth() + doubleOffset, rect.getHeight() + doubleOffset);
        Ellipse2D.Double circle = new Ellipse2D.Double();
        circle.setFrame(rect);
        Area hotSpotArea = new Area(circle);
        K box = nr.getLabel().getBox();
        double yPad = 3.0;
        rect.setRect(rect.getX(), box.\u00e5() + yPad, rect.getWidth(), box.\u00e2() - yPad * 1.2);
        Area labelRectArea = new Area(rect);
        hotSpotArea.intersect(labelRectArea);
        g2D.setPaint(UIManager.getLookAndFeelDefaults().getColor("graph-entity-selection-label-bg"));
        g2D.fill(hotSpotArea);
    }

    public static void paintCollectionNodeBallLabelBackground(BA nr, Graphics2D g2D, Rectangle2D rect, double strokeWidth, double ballSize) {
        double offset = strokeWidth / 2.0;
        double doubleOffset = offset * 2.0;
        rect.setRect(rect.getX() - offset, rect.getY() - offset, rect.getWidth() + doubleOffset, rect.getHeight() + doubleOffset);
        Area hotSpotArea = new Area(rect);
        K box = nr.getLabel().getBox();
        double yPad = box.\u00e2() / 6.0;
        rect.setRect(rect.getX(), box.\u00e5() + yPad, rect.getWidth(), box.\u00e2() - yPad * 1.2);
        Area labelRectArea = new Area(rect);
        hotSpotArea.intersect(labelRectArea);
        g2D.setPaint(UIManager.getLookAndFeelDefaults().getColor("graph-entity-selection-label-bg"));
        g2D.fill(hotSpotArea);
    }

    public static Rectangle2D getRectangle2D(BA nr, float strokeWidth) {
        EntityPainter entityPainter = null;
        if (nr instanceof LightweightEntityRealizer) {
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
            entityPainter = EntityPainterSettings.getDefault().getEntityPainter(realizer.getGraphEntity().getGraphID());
        }
        if (entityPainter != null && !"Main".equals(entityPainter.getName())) {
            double height;
            double x2 = nr.getX() - (double)(strokeWidth / 2.0f);
            double y2 = nr.getY() - (double)(strokeWidth / 2.0f);
            double width = nr.getWidth() + (double)strokeWidth;
            double dimension = height = nr.getHeight() + (double)strokeWidth;
            if (width < height) {
                dimension = width;
            } else {
                x2 += (width - dimension) / 2.0;
            }
            return new Rectangle2D.Double(x2, y2, dimension, dimension);
        }
        double x3 = nr.getX() - (double)(strokeWidth / 2.0f);
        double y3 = nr.getY() - (double)(strokeWidth / 2.0f);
        double width = nr.getWidth() + (double)strokeWidth;
        double dimension = 104.0;
        return new Rectangle2D.Double(x3 += (width - dimension) / 2.0, y3, dimension, dimension);
    }

    public static Rectangle2D calculateFontFallbackSize(X label, FontRenderContext frc) {
        String text = label.getText();
        Font preferredFont = label.getFont();
        Rectangle2D bounds = FontFallbackStringPainter.getBounds((FontRenderContext)frc, (String)text, (Font)preferredFont);
        Insets insets = label.getInsets();
        if (insets == null) {
            insets = X.defaultInsets;
        }
        return new Rectangle2D.Double(0.0, 0.0, bounds.getWidth() + (double)(insets == null ? 0 : insets.left + insets.right), bounds.getHeight() + (double)(insets == null ? 0 : insets.top + insets.bottom));
    }
}

