/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.ui.graph.CustomProperties;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewRegistry;
import com.paterva.maltego.ui.graph.nodes.BookmarkPropertyEditor;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import com.paterva.maltego.ui.graph.transactions.TransactionGeneralBatcher;
import com.paterva.maltego.ui.graph.transactions.TransactionGeneralBatcherRegistry;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class EntityProperties
extends PartProperties {
    protected EntityProperties() {
    }

    public static Sheet createBasicSheet(Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        return EntityProperties.createBasicSheet(null, node, entity, spec);
    }

    public static Sheet createBasicSheet(GraphID graphID, Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        entity = entity.createClone();
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        Sheet.Set defaultSet = sheet.get("");
        defaultSet.put((Node.Property)new Type(node));
        EntityRegistry registry = EntityProperties.getRegistry(node);
        EntityProperties.addProperties(EntityProperties.getPropertySheetFactory(graphID), (SpecRegistry<? extends TypeSpec>)registry, sheet, (MaltegoPart<? extends Guid>)entity, EntityProperties.getSpecPropertyConfig(registry, entity.getTypeName()));
        String value = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entity);
        if (value != null) {
            defaultSet.put((Node.Property)new Value(node));
        }
        return sheet;
    }

    public static Sheet createSheet(Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        return EntityProperties.createSheet(null, node, entity, spec);
    }

    public static Sheet createSheet(GraphID graphID, Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        Sheet sheet = EntityProperties.createBasicSheet(graphID, node, entity, spec);
        Sheet.Set graphSet = PropertySheetFactory.getSet((Sheet)sheet, (String)"graphinfo", (String)"Graph info", (String)"Properties related to the graph");
        CustomProperties customProperties = null;
        GraphView graphView = GraphViewRegistry.get(graphID);
        if (graphView != null) {
            customProperties = graphView.getCustomProperties();
        }
        if (customProperties != null) {
            List<Node.Property<?>> properties = customProperties.getProperties(node);
            for (Node.Property<?> property : properties) {
                graphSet.put(property);
            }
        } else {
            graphSet.put((Node.Property)new Weight(node));
            graphSet.put((Node.Property)new IncomingLinks(node));
            graphSet.put((Node.Property)new OutgoingLinks(node));
            graphSet.put((Node.Property)new Bookmark(node));
        }
        return sheet;
    }

    public static Sheet createSheetNoLinkInfo(Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        return EntityProperties.createSheetNoLinkInfo(null, node, entity, spec);
    }

    public static Sheet createSheetNoLinkInfo(GraphID graphID, Node node, MaltegoEntity entity, MaltegoEntitySpec spec) {
        Sheet sheet = EntityProperties.createBasicSheet(graphID, node, entity, spec);
        Sheet.Set graphSet = PropertySheetFactory.getSet((Sheet)sheet, (String)"graphinfo", (String)"Graph info", (String)"Properties related to the graph");
        graphSet.put((Node.Property)new Weight(node));
        graphSet.put((Node.Property)new Bookmark(node));
        return sheet;
    }

    private static PropertyConfiguration getSpecPropertyConfig(EntityRegistry registry, String specName) {
        DisplayDescriptorCollection specProperties = EntityProperties.getSpecProperties(registry, specName);
        GroupDefinitions specGroups = EntityProperties.getSpecGroups(registry, specName);
        return new PropertyConfiguration((DisplayDescriptorEnumeration)specProperties, specGroups);
    }

    private static DisplayDescriptorCollection getSpecProperties(EntityRegistry registry, String specName) {
        return InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)specName);
    }

    private static GroupDefinitions getSpecGroups(EntityRegistry registry, String specName) {
        return InheritanceHelper.getAggregatedPropertyGroups((SpecRegistry)registry, (String)specName);
    }

    private static EntityRegistry getRegistry(Node node) {
        GraphID graphID = (GraphID)node.getLookup().lookup(GraphID.class);
        return graphID != null ? EntityRegistry.forGraphID((GraphID)graphID) : EntityRegistry.getDefault();
    }

    public static class Bookmark
    extends NodePropertySupport.ReadWrite<Integer> {
        private PropertyEditor _editor;

        public Bookmark(Node node) {
            super(node, "maltego.fixed.bookmark", Integer.class, "Bookmark", "The bookmark color of the entity if it is bookmarked.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity entity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            return entity.getBookmark();
        }

        public void setValue(Integer val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null) {
                return;
            }
            GraphEntity graphEntity = (GraphEntity)this.node().getLookup().lookup(GraphEntity.class);
            MaltegoEntity entity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            int before = entity.getBookmark();
            TransactionGeneralBatcher batcher = TransactionGeneralBatcherRegistry.get(graphEntity.getGraphID());
            batcher.entityBookmarkChanged(entity, before, val);
        }

        public synchronized PropertyEditor getPropertyEditor() {
            if (this._editor == null) {
                OptionItemCollection items = new OptionItemCollection(Integer.TYPE, null);
                items.add((Object)-1);
                for (int i = 0; i < BookmarkFactory.getDefault().getBookmarkCount(); ++i) {
                    items.add((Object)i);
                }
                this._editor = new BookmarkPropertyEditor(items);
            }
            return this._editor;
        }
    }

    public static class Value
    extends NodePropertySupport.ReadOnly<String> {
        public Value(Node node) {
            super(node, "maltego.calculated.value", String.class, "Value", "The main value of entity.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity entity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            EntityRegistry registry = EntityProperties.getRegistry(this.node());
            return InheritanceHelper.getValueString((SpecRegistry)registry, (TypedPropertyBag)entity);
        }

        @Override
        public void setValue(String t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        }
    }

    public static class OutgoingLinks
    extends NodePropertySupport.ReadOnly<Integer> {
        public OutgoingLinks(Node node) {
            super(node, "maltego.fixed.outgoinglinks", Integer.class, "Outgoing", "The number of links that have this entity as a source.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            int links = 1;
            try {
                GraphEntity graphEntity = (GraphEntity)this.node().getLookup().lookup(GraphEntity.class);
                GraphID graphID = graphEntity.getGraphID();
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                    links = structureReader.getOutgoing((EntityID)graphEntity.getID()).size();
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return links;
        }
    }

    public static class IncomingLinks
    extends NodePropertySupport.ReadOnly<Integer> {
        public IncomingLinks(Node node) {
            super(node, "maltego.fixed.incominglinks", Integer.class, "Incoming", "The number of links that have this entity as a target.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            int links = 1;
            try {
                GraphEntity graphEntity = (GraphEntity)this.node().getLookup().lookup(GraphEntity.class);
                GraphID graphID = graphEntity.getGraphID();
                if (GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                    links = structureReader.getIncoming((EntityID)graphEntity.getID()).size();
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return links;
        }
    }

    public static class Weight
    extends NodePropertySupport.ReadOnly<Integer> {
        public Weight(Node node) {
            super(node, "maltego.fixed.weight", Integer.class, "Weight", "Weight is a measurement of the rank of an entity resulting from a search operation.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity entity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            return entity.getWeight();
        }
    }

    public static class Type
    extends NodePropertySupport.ReadOnly<String> {
        public Type(Node node) {
            super(node, "maltego.fixed.type", String.class, "Type", "The type of entity.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)this.node().getLookup().lookup(MaltegoEntitySpec.class);
            if (spec == null) {
                MaltegoEntity entity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
                return entity.getTypeName();
            }
            return spec.getDisplayName();
        }
    }
}

