/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMergeCallback;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.GraphMergerFactory;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.Point;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class PositioningGraphMerger {
    private final GraphID _destGraphID;
    private final GraphID _srcGraphID;
    private final SimilarStrings _description;
    private GraphMergeStrategy _graphMergeStrat;
    private GraphMerger _graphMerger;

    public PositioningGraphMerger(GraphID destGraphID, GraphID srcGraphID, SimilarStrings description) {
        this._destGraphID = destGraphID;
        this._srcGraphID = srcGraphID;
        this._description = description;
        this.init();
    }

    private void init() {
        this.setGraphMergeStrat((GraphMergeStrategy)new GraphMergeStrategy.PreferNew());
        this.setGraphMerger(this.createGraphMerger(null));
    }

    public GraphID getDestGraphID() {
        return this._destGraphID;
    }

    public GraphID getSrcGraphID() {
        return this._srcGraphID;
    }

    public SimilarStrings getDescription() {
        return this._description;
    }

    public GraphMergeStrategy getGraphMergeStrat() {
        return this._graphMergeStrat;
    }

    public void setGraphMergeStrat(GraphMergeStrategy graphMergeStrat) {
        this._graphMergeStrat = graphMergeStrat;
    }

    protected GraphMerger getGraphMerger() {
        return this._graphMerger;
    }

    protected void setGraphMerger(GraphMerger graphMerger) {
        this._graphMerger = graphMerger;
    }

    public void mergeGraphs() {
        this._graphMerger.append();
    }

    public void selectSourceNodes() {
        final Map map = this._graphMerger.getEntityMapping();
        if (map != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HashSet<Guid> toSelect = new HashSet<Guid>();
                    for (Map.Entry entry : map.entrySet()) {
                        MaltegoEntity destEntity = (MaltegoEntity)entry.getValue();
                        toSelect.add(destEntity.getID());
                    }
                    GraphSelection selection = GraphSelection.forGraph((GraphID)PositioningGraphMerger.this._destGraphID);
                    selection.setSelectedModelEntities(toSelect);
                }
            });
        }
        this._graphMerger = null;
    }

    protected GraphMerger createGraphMerger(EntityFilter filter) {
        GraphID destGraphID = this.getDestGraphID();
        GraphID srcGraphID = this.getSrcGraphID();
        GraphMatchStrategy matchStrat = new GraphMatchStrategy(StatelessMatchingRuleDescriptor.Default, StatelessMatchingRuleDescriptor.Default);
        PositioningGraphMergeCallback callback = new PositioningGraphMergeCallback(destGraphID, srcGraphID);
        GraphMerger graphMerger = GraphMergerFactory.getDefault().create(this._description, matchStrat, this.getGraphMergeStrat(), (GraphMergeCallback)callback, false, true, false);
        graphMerger.setGraphs(destGraphID, srcGraphID, filter);
        return graphMerger;
    }

    private static class PositioningGraphMergeCallback
    implements GraphMergeCallback {
        private GraphLayoutWriter _destLayoutWriter;
        private GraphLayoutReader _srcLayoutReader;

        public PositioningGraphMergeCallback(GraphID destGraphID, GraphID srcGraphID) {
            try {
                GraphStore srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(srcGraphID);
                this._srcLayoutReader = srcGraphStore.getGraphLayoutStore().getLayoutReader();
                GraphStore destGraphStore = GraphStoreRegistry.getDefault().forGraphID(destGraphID);
                this._destLayoutWriter = destGraphStore.getGraphLayoutStore().getLayoutWriter();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void onEntityTransferred(MaltegoEntity destEntity, MaltegoEntity srcEntity) {
            try {
                Point center = this._srcLayoutReader.getCenter((EntityID)srcEntity.getID());
                this._destLayoutWriter.setCenter((EntityID)destEntity.getID(), center);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void onEntitiesMerged(MaltegoEntity destEntity, MaltegoEntity srcEntity) {
        }

        public void onLinkTransferred(MaltegoLink destLink, MaltegoLink srcLink) {
        }

        public void onLinksMerged(MaltegoLink destLink, MaltegoLink srcLink) {
        }

        public void onEntitiesDeleted(Set<MaltegoEntity> entities, Map<EntityID, Point> entityCenters) {
        }

        public void onLinksDeleted(Map<MaltegoLink, LinkEntityIDs> links) {
        }
    }
}

