/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.util.ui.dialog.FullScreenManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.windows.TopComponent;

public class TopGraphFullScreenSynchronizer {
    private static TopGraphFullScreenSynchronizer _instance;
    private GraphEditorRegistry _registry;
    private PropertyChangeListener _listener = new TopMostListener();

    static void create() {
        _instance = new TopGraphFullScreenSynchronizer();
    }

    private TopGraphFullScreenSynchronizer() {
        this._registry = GraphEditorRegistry.getDefault();
        this._registry.addPropertyChangeListener(this._listener);
    }

    private static class TopMostListener
    implements PropertyChangeListener {
        private TopMostListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("topmost".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.makeTopGraphFullScreen();
                    }
                });
            }
        }

        private void makeTopGraphFullScreen() {
            FullScreenManager fullScreenManager = FullScreenManager.getDefault();
            if (fullScreenManager.isFullScreen()) {
                fullScreenManager.exitFullScreen();
                TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
                if (topmost != null) {
                    fullScreenManager.setFullScreen((JComponent)topmost.getParent(), null);
                }
            }
        }
    }
}

