/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.ui.SessionInfoForm;
import com.paterva.maltego.util.ui.BackgroundWorker;
import com.paterva.maltego.util.ui.BackgroundWorkerControl;
import com.paterva.maltego.util.ui.BackgroundWorkerListener;
import com.paterva.maltego.util.ui.VFlowLayout;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShareNewGraphForm
extends JPanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color innerBackground = LAF.getColor("collaboration-connection-status-panel-bg");
    private final Color bg = LAF.getColor("3-main-dark-color");
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final SessionInfoForm _roomInfoForm = new SessionInfoForm();
    private final BackgroundWorkerControl _workerControl = new BackgroundWorkerControl();
    private final CardLayout _cardLayout = new CardLayout();
    private final JPanel _statusOuterPanel = new JPanel(new BorderLayout());
    private final JPanel _statusPanel = new JPanel(this._cardLayout);
    private final JTextArea _errorText = new JTextArea();
    boolean _inError = false;
    private static final String WORKER = "worker";
    private static final String EMPTY = "empty";
    private static final String ERROR = "error";
    public static final String ERROR_STATE = "ERROR_STATE";

    public ShareNewGraphForm() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        this.add(innerPanel);
        innerPanel.setBackground(this.bg);
        innerPanel.setLayout((LayoutManager)new VFlowLayout(0, 3));
        innerPanel.add(this._roomInfoForm);
        this._roomInfoForm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShareNewGraphForm.this.validateFormData();
            }
        });
        this._statusOuterPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this._statusOuterPanel.setBackground(this.bg);
        this._statusOuterPanel.add(this._statusPanel);
        innerPanel.add(this._statusOuterPanel);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.setBackground(this.innerBackground);
        errorPanel.add(this._errorText);
        this._errorText.setBackground(errorPanel.getBackground());
        this._errorText.setFont(FontUtils.scale((Font)this._errorText.getFont(), (float)1.0f).deriveFont(1));
        this._errorText.setForeground(LAF.getColor("7-dark-red"));
        this._errorText.setEditable(false);
        this._errorText.setLineWrap(true);
        this._errorText.setWrapStyleWord(true);
        this._errorText.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this._workerControl.setBackground(this.innerBackground);
        this._workerControl.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        Dimension sizeWorker = this._workerControl.getPreferredSize();
        this._statusPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        this._workerControl.setPreferredSize(new Dimension(sizeWorker.width, sizeWorker.height + 12));
        this._statusPanel.add((Component)this._workerControl, WORKER);
        JPanel empty = new JPanel();
        empty.setBackground(this.innerBackground);
        this._statusPanel.add((Component)empty, EMPTY);
        this._statusPanel.add((Component)errorPanel, ERROR);
        sizeWorker = this._workerControl.getPreferredSize();
        Dimension sizeError = errorPanel.getPreferredSize();
        this._statusPanel.setPreferredSize(new Dimension(Math.max(sizeWorker.width, sizeError.width), sizeWorker.height + sizeError.height));
        this._cardLayout.show(this._statusPanel, EMPTY);
        this._workerControl.addBackgroundWorkerListener((BackgroundWorkerListener)new WorkerListener());
    }

    public boolean validateFormData() {
        String dns;
        String errorMsg = "";
        boolean inError = false;
        this._roomInfoForm.clearAllErrors();
        if (this._roomInfoForm.isUseOtherServer()) {
            dns = this._roomInfoForm.getServerDnsName();
            if (dns == null || dns.trim().isEmpty()) {
                this._roomInfoForm.enableErrorState("OTHER_SERVER_DNS_NAME");
                inError = true;
                errorMsg = "The sever DNS name must be specified";
            }
        } else if (this._roomInfoForm.isUsePrivatePatervaServer() && ((dns = this._roomInfoForm.getPrivatePatervaServerDnsName()) == null || dns.trim().isEmpty())) {
            this._roomInfoForm.enableErrorState("PRIVATE_PATERVA_SERVER_DNS_NAME");
            inError = true;
            errorMsg = "The sever name or IP must be specified";
        }
        if (this._roomInfoForm.getAlias().isEmpty()) {
            this._roomInfoForm.enableErrorState("USER_ALIAS");
            inError = true;
            errorMsg = "User alias must be specified";
        }
        if (this._roomInfoForm.getSession().isEmpty()) {
            this._roomInfoForm.enableErrorState("SESSION_NAME");
            inError = true;
            errorMsg = "A session name must be specified";
        }
        if (inError) {
            this.showError(errorMsg);
        } else {
            this.resetError();
        }
        if (this._inError != inError) {
            Boolean oldVal = this._inError;
            Boolean newVal = inError;
            this._inError = inError;
            this.fireChanged(ERROR_STATE, oldVal, newVal);
        }
        return this._inError;
    }

    public CollaborationSessionInfo getChatRoomInfo() {
        return this._roomInfoForm.getChatRoomInfo();
    }

    public void addChangeListener(PropertyChangeListener l) {
        this._changeSupport.addPropertyChangeListener(l);
    }

    public void fireChanged(String propName, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(propName, oldValue, newValue);
    }

    public void storeInfo() {
        this._roomInfoForm.storeInfo();
    }

    public void start(String description) {
        this._cardLayout.show(this._statusPanel, WORKER);
        this._roomInfoForm.setIsWorking(true);
        this._workerControl.start((Object)this._roomInfoForm.getChatRoomInfo(), description);
    }

    public void showError(String error) {
        this._cardLayout.show(this._statusPanel, ERROR);
        this._errorText.setText(error);
    }

    public void resetError() {
        this._cardLayout.show(this._statusPanel, EMPTY);
        this._errorText.setText("");
    }

    public void cancel() {
        this._workerControl.cancel();
    }

    public void addBackgroundWorkerListener(BackgroundWorkerListener listener) {
        this._workerControl.addBackgroundWorkerListener(listener);
    }

    public void removeBackgroundWorkerListener(BackgroundWorkerListener listener) {
        this._workerControl.removeBackgroundWorkerListener(listener);
    }

    public BackgroundWorker getWorker() {
        return this._workerControl.getWorker();
    }

    public void setWorker(BackgroundWorker worker) {
        this._workerControl.setWorker(worker);
    }

    public boolean isBusy() {
        return this._workerControl.isBusy();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private class WorkerListener
    implements BackgroundWorkerListener {
        private WorkerListener() {
        }

        public void workerCompleted(Object result) {
            ShareNewGraphForm.this._roomInfoForm.setIsWorking(false);
        }

        public void workerFailed(Throwable error) {
            ShareNewGraphForm.this._roomInfoForm.setIsWorking(false);
        }

        public void workerCancelled() {
            ShareNewGraphForm.this._roomInfoForm.setIsWorking(false);
        }
    }
}

