/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.session.ChatSessionRegistry;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.Bundle;
import com.paterva.maltego.collab.ui.ChatRoomCloseHandler;
import com.paterva.maltego.collab.ui.ChatWindowController;
import com.paterva.maltego.collab.ui.ShareGraphFormContainer;
import com.paterva.maltego.collab.ui.ShareNewGraphForm;
import com.paterva.maltego.collab.ui.SharedGraphBackgroundWorkerListener;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public class ShareCurrentGraphAction
extends TopGraphAction {
    protected void actionPerformed(TopComponent tc) {
        this.performAction(tc);
    }

    public void performAction(TopComponent tc) {
        GraphDataObject gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
        if (gdo != null) {
            Dialog dialog;
            ShareGraphFormContainer formContainer = new ShareGraphFormContainer(gdo);
            final Dialog[] dialogHolder = formContainer.getDialogHolder();
            final ShareNewGraphForm form = formContainer.getForm();
            final JButton connectButton = formContainer.getConnectButton();
            final JButton cancelButton = formContainer.getCancelButton();
            formContainer.addBackgroundWorkerListener(new SharedGraphBackgroundWorkerListener(formContainer){

                public void workerCompleted(Object result) {
                    GraphChatRoom room = (GraphChatRoom)((Object)result);
                    ChatRoomCloseHandler closeHandler = new ChatRoomCloseHandler(room);
                    ChatRoomTopComponentRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)closeHandler);
                    room.initializationComplete();
                    dialogHolder[0].setVisible(false);
                    dialogHolder[0].dispose();
                    ChatSessionRegistry.getDefault().addChatRoom((ChatRoom)room);
                    ChatWindowController.get().forceUpdate();
                }
            });
            ActionListener connectListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == connectButton) {
                        connectButton.setEnabled(false);
                        form.start("Establishing collaboration session...");
                    } else if (e.getSource() == cancelButton) {
                        cancelButton.setEnabled(false);
                        if (form.isBusy()) {
                            form.cancel();
                        } else {
                            dialogHolder[0].setVisible(false);
                            dialogHolder[0].dispose();
                        }
                    }
                }
            };
            DialogDescriptor dd = new DialogDescriptor((Object)form, String.format("Sharing Current Graph: %s", gdo.getName()), true, new Object[]{connectButton, cancelButton}, (Object)connectButton, 0, HelpCtx.DEFAULT_HELP, connectListener);
            dialogHolder[0] = dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setMinimumSize(dialog.getPreferredSize());
            dialog.setVisible(true);
            form.storeInfo();
        }
    }

    public String getName() {
        return Bundle.CTL_ShareCurrentGraph();
    }

    protected String iconResource() {
        return "com/paterva/maltego/collab/resources/ChatSession.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean isEnabled(TopComponent tc) {
        boolean enabled = false;
        if (tc != null) {
            ChatRoomCookie cookie = (ChatRoomCookie)tc.getLookup().lookup(ChatRoomCookie.class);
            enabled = cookie == null;
        }
        return enabled;
    }
}

