/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ChatWindowController {
    private static final String TC_CHAT_BOX = "ChatBoxTopComponent";
    private static final String TC_USERS = "UsersTopComponent";
    private static ChatWindowController _instance;
    private HideShowTCListener _hideShowListener;
    private Map<String, Boolean> _topMap = new HashMap<String, Boolean>();

    public static synchronized ChatWindowController create() {
        if (_instance == null) {
            _instance = new ChatWindowController();
        }
        return _instance;
    }

    public static synchronized ChatWindowController get() {
        return _instance;
    }

    public ChatWindowController() {
        this._hideShowListener = new HideShowTCListener();
        ChatRoomTopComponentRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this._hideShowListener);
        this.updateChatBoxWindow(null);
        this.updateUsersWindow(null);
    }

    public void forceUpdate() {
        ChatRoomTopComponentRegistry registry = ChatRoomTopComponentRegistry.getDefault();
        registry.forceUpdate();
    }

    private void updateChatBoxWindow(ChatRoom chatRoom) {
        TopComponent chatBoxTC = WindowManager.getDefault().findTopComponent(TC_CHAT_BOX);
        this.setOpen(chatBoxTC, TC_CHAT_BOX, chatRoom != null);
    }

    private void updateUsersWindow(ChatRoom chatRoom) {
        TopComponent chatBoxTC = WindowManager.getDefault().findTopComponent(TC_USERS);
        this.setOpen(chatBoxTC, TC_USERS, chatRoom != null);
    }

    private void setOpen(TopComponent tc, String id, boolean open) {
        if (tc != null) {
            if (open) {
                if (!tc.isOpened()) {
                    tc.open();
                    Boolean topMost = this._topMap.get(id);
                    if (topMost == null || topMost.booleanValue()) {
                        tc.requestVisible();
                    }
                }
            } else if (tc.isOpened()) {
                Boolean topMost = null;
                Mode mode = WindowManager.getDefault().findMode(tc);
                if (mode != null) {
                    topMost = tc.equals(mode.getSelectedTopComponent());
                }
                this._topMap.put(id, topMost);
                tc.close();
            }
        }
    }

    private class HideShowTCListener
    implements PropertyChangeListener {
        private HideShowTCListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("chatRoomActiveChanged".equals(evt.getPropertyName())) {
                ChatRoom chatRoom = ChatRoomTopComponentRegistry.getDefault().getActiveChatRoom();
                ChatWindowController.this.updateChatBoxWindow(chatRoom);
                ChatWindowController.this.updateUsersWindow(chatRoom);
            }
        }
    }
}

