/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.session.xmpp.bosh.BoshSocketFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.SocketFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;

public class BoshConfiguration
extends ConnectionConfiguration {
    private final int _port;
    private final boolean _isHttps;
    private final String _host;
    private final String _protocol;
    private String _path = "/http-bind/";
    private URI _uri;

    public BoshConfiguration(String host, int port, ProxyInfo proxyInfo, boolean isHttps) throws URISyntaxException {
        super(host, port, proxyInfo);
        this._port = port;
        this._host = host;
        this._isHttps = isHttps;
        this._protocol = isHttps ? "https" : "http";
        this.buildURI();
    }

    private void buildURI() throws URISyntaxException {
        if (!this._path.startsWith("/")) {
            this.setPath('/' + this.getPath());
        }
        if (!this._path.endsWith("/")) {
            this.setPath(this.getPath() + '/');
        }
        String uri = String.format("%s://%s%s%s", this._protocol, this._host, this._port == 80 ? "" : ":" + this._port, this.getPath());
        this._uri = new URI(uri);
    }

    public URI getURI() {
        return this._uri;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) throws URISyntaxException {
        if (path == null) {
            path = "";
        }
        this._path = path;
        this.buildURI();
    }

    public ProxyInfo getProxy() {
        return this.proxy;
    }

    public boolean isHttps() {
        return this._isHttps;
    }

    public SocketFactory getSocketFactory() {
        BoshSocketFactory factory = new BoshSocketFactory(this);
        return factory;
    }
}

