/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.AbstractConnectionState;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import java.util.Collections;

public class StateDisconnecting
extends AbstractConnectionState {
    public StateDisconnecting() {
        super(ConnectionStatus.Disconnecting, false);
    }

    @Override
    protected void run() {
        try {
            ((ConnectionController)this.getStateMachine()).closeSession();
        }
        catch (CollaborationException ex) {
            this.debug("Error closing session: " + (Object)((Object)ex));
        }
        finally {
            this.setNextState(this.getErrorState());
        }
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        this.localQueue().sendPayload(to, xml);
        this.graphProvider().addToResolverQueue(Collections.singleton(xml));
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
        this.debug("Ignoring status update");
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) {
        this.debug("Ignoring payload of type " + payloads.typeString());
    }

    @Override
    void sessionDropped(Exception e) {
        this.debug("Ignoring session event");
    }
}

