/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.GuidedTourUtil;
import com.maltego.guided.tour.ui.StepNavigationPanel;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.MaltegoUrl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EntityPaletteDialog
extends TourDialog {
    private TopComponent paletteTC;
    private TourStep tourStep = TourStep.DEFAULT;
    private StepNavigationPanel navigationPanel;
    private TitlePanel titlePanel;

    public EntityPaletteDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(370, 0));
        this.initComponents();
        this.setEntityTC();
        this.adjustLocation();
        this.adjustShape();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_STEP_BACKGROUND);
    }

    @Override
    protected Point getRelativeLocation() {
        return new Point(190, 30);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
        this.navigationPanel.setTourStep(tourStep);
    }

    private void setEntityTC() {
        this.paletteTC = WindowManager.getDefault().findTopComponent("CommonPalette");
        this.setLocationOnComponent((Component)this.paletteTC);
    }

    private void adjustShape() {
        Area rectangle = new Area(new Rectangle(10, 0, this.getWidth() - 10, this.getHeight()));
        Area triangle = new Area(new Polygon(new int[]{0, 10, 10}, new int[]{30, 20, 40}, 3));
        rectangle.add(triangle);
        this.setShape(rectangle);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JLabel animationLabel = new JLabel();
        JTextArea contentTextArea = new JTextArea();
        this.navigationPanel = new StepNavigationPanel();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(EntityPaletteDialog.class, (String)"EntityPaletteDialog.titlePanel.title"));
        animationLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/anim_drag-entity.gif")));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(9);
        contentTextArea.setText(NbBundle.getMessage(EntityPaletteDialog.class, (String)"EntityPaletteDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.navigationPanel, -2, 0, Short.MAX_VALUE).addComponent(contentTextArea, GroupLayout.Alignment.TRAILING).addComponent(animationLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap(15, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(animationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(contentTextArea, -2, -1, -2).addGap(12, 12, 12).addComponent(this.navigationPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    public static class Presenter
    extends TourDialogPresenter<EntityPaletteDialog> {
        @Override
        protected EntityPaletteDialog createTourDialog(Frame frame) {
            return new EntityPaletteDialog(frame);
        }

        @Override
        public Supplier<Rectangle> getFocusArea() {
            TopComponent paletteTC = WindowManager.getDefault().findTopComponent("CommonPalette");
            return GuidedTourUtil.createTopComponentFocusArea(paletteTC);
        }

        @Override
        public Consumer<Graphics2D> getPainter() {
            TopComponent paletteTC = WindowManager.getDefault().findTopComponent("CommonPalette");
            return GuidedTourUtil.createTopComponentFocusAreaPainter(paletteTC);
        }

        @Override
        public String learnMoreLink() {
            return MaltegoUrl.getCurrent().getGotoOnboardingFirstGraph();
        }
    }
}

