/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.view;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.certificates.ui.view.CertificateCallback;
import java.io.IOException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class CertificateDownloader {
    private static final Logger LOG = Logger.getLogger(CertificateDownloader.class.getName());

    public void get(URL url, CertificateCallback callback) {
        Thread workerThread = new Thread(() -> {
            String msg = null;
            Optional cert = null;
            try {
                HttpAgent agent = new HttpAgent(url);
                agent.setTrustAllCerts(true);
                cert = agent.getServerCertificate();
            }
            catch (NoTrustedCertificateChainFoundException ex) {
                LOG.log(Level.WARNING, "No trusted certificate chain found: {0}", ex.toString());
            }
            catch (Exception ex) {
                if (ex instanceof IOException && !(ex instanceof SSLException)) {
                    msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                    LOG.log(Level.WARNING, msg);
                }
                Exceptions.printStackTrace((Throwable)ex);
            }
            X509Certificate finalCert = cert == null ? null : (X509Certificate)cert.orElse(null);
            String finalMsg = msg;
            SwingUtilities.invokeLater(() -> {
                if (finalCert != null) {
                    callback.onCertificate(finalCert);
                } else {
                    callback.onCertificateMissingOrInvalid(finalMsg);
                }
            });
        }, "Certificate Downloader");
        workerThread.start();
    }
}

