/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.copy;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.copy.GraphCopier;
import com.paterva.maltego.graph.store.copy.GraphCopyContext;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultGraphCopier
implements GraphCopier {
    @Override
    public void copy(GraphCopyContext copyCtx) throws GraphStoreException {
        this.preCopy(copyCtx);
        this.doCopy(copyCtx);
        this.postCopy(copyCtx);
    }

    protected void preCopy(GraphCopyContext copyCtx) {
    }

    protected void postCopy(GraphCopyContext copyCtx) {
    }

    public void doCopy(GraphCopyContext copyCtx) throws GraphStoreException {
        this.copyLayout(copyCtx);
        this.copyStructure(copyCtx);
        this.copyData(copyCtx);
    }

    private void copyLayout(GraphCopyContext copyCtx) throws GraphStoreException {
        Set<EntityID> entities = copyCtx.getEntities();
        Set<LinkID> links = copyCtx.getLinks();
        GraphLayoutReader srcLayoutReader = copyCtx.getSrcLayoutReader();
        Map<EntityID, Point> centers = srcLayoutReader.getCenters(entities);
        Map<LinkID, List<Point>> paths = srcLayoutReader.getPaths(links);
        GraphLayoutWriter destLayoutWriter = copyCtx.getDestLayoutWriter();
        destLayoutWriter.addEntities(centers);
        destLayoutWriter.addLinks(paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStructure(GraphCopyContext copyCtx) throws GraphStoreException {
        Set<EntityID> entities = copyCtx.getEntities();
        Set<LinkID> links = copyCtx.getLinks();
        GraphStructureReader srcStructureReader = copyCtx.getSrcStructureReader();
        Map<LinkID, LinkEntityIDs> connections = srcStructureReader.getEntities(links);
        Map<EntityID, Boolean> pinned = srcStructureReader.getPinned(entities);
        GraphStructureWriter destStructureWriter = copyCtx.getDestStructureWriter();
        destStructureWriter.beginUpdate();
        try {
            destStructureWriter.add(entities);
            destStructureWriter.connect(connections);
            destStructureWriter.setPinned(pinned);
        }
        finally {
            destStructureWriter.endUpdate(null);
        }
    }

    private void copyData(GraphCopyContext copyCtx) throws GraphStoreException {
        GraphDataStoreWriter destDataWriter = copyCtx.getDestDataWriter();
        destDataWriter.beginUpdate();
        try {
            this.copyEntityData(copyCtx);
            this.copyLinkData(copyCtx);
        }
        finally {
            destDataWriter.endUpdate();
        }
    }

    private void copyEntityData(GraphCopyContext copyCtx) throws GraphStoreException {
        Set<EntityID> entities = copyCtx.getEntities();
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setIDs(entities);
        GraphDataStoreReader srcDataReader = copyCtx.getSrcDataReader();
        Map<EntityID, MaltegoEntity> maltegoEntities = srcDataReader.getEntities(query);
        GraphDataStoreWriter destDataWriter = copyCtx.getDestDataWriter();
        destDataWriter.putEntities(maltegoEntities.values());
    }

    private void copyLinkData(GraphCopyContext copyCtx) throws GraphStoreException {
        Set<LinkID> links = copyCtx.getLinks();
        LinksDataQuery query = new LinksDataQuery();
        query.setIDs(links);
        GraphDataStoreReader srcDataReader = copyCtx.getSrcDataReader();
        Map<LinkID, MaltegoLink> maltegoLinks = srcDataReader.getLinks(query);
        GraphDataStoreWriter destDataWriter = copyCtx.getDestDataWriter();
        destDataWriter.putLinks(maltegoLinks.values());
    }
}

