/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.format;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.TableIODecorator;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class LinkTableFormatter
extends TableIODecorator {
    public static String LINK_START_ID = "LinkID";
    protected int offset = 0;
    protected List<String> linkHeader;
    protected LinkedHashSet<PropertyDescriptor> properties;

    public LinkTableFormatter(TableIO table) {
        super(table);
    }

    public void addLink(EntityID sourceID, MaltegoLink link, EntityID targetID) {
        this.updateHeader(link);
        ArrayList<String> row = new ArrayList<String>();
        for (int index = 0; index < this.offset; ++index) {
            row.add("");
        }
        row.add(((LinkID)link.getID()).toString());
        row.add(sourceID.toString());
        row.add(targetID.toString());
        for (PropertyDescriptor property : this.properties) {
            Object value = link.getValue(property);
            row.add(value == null ? "" : Converter.convertTo((Object)value, (Class)property.getType()));
        }
        this.addRow(row);
    }

    public void addLinks(List<EntityID> sourceIDs, List<MaltegoLink> links, List<EntityID> targetIDs) {
        Iterator<EntityID> sources = sourceIDs.iterator();
        Iterator<EntityID> targets = targetIDs.iterator();
        Iterator<MaltegoLink> iterator = links.iterator();
        while (sources.hasNext() && targets.hasNext() && iterator.hasNext()) {
            this.addLink(sources.next(), iterator.next(), targets.next());
        }
    }

    public Iterator<Data> linkIterator() {
        return new Reader();
    }

    protected LinkFactory linkFactory() {
        return LinkFactory.getDefault();
    }

    protected void createLinkHeader(MaltegoLink link) {
        if (this.linkHeader != null) {
            return;
        }
        if (this.decorated.getRowCount() > 0) {
            this.offset = this.decorated.rowIterator().next().size();
        }
        int size = link.getProperties().size() + 3;
        this.properties = new LinkedHashSet(size);
        this.linkHeader = new ArrayList<String>(size + this.offset);
        for (int index = 0; index < this.offset; ++index) {
            this.linkHeader.add("");
        }
        this.linkHeader.add(LINK_START_ID);
        this.linkHeader.add("SourceEntityID");
        this.linkHeader.add("TargetEntityID");
        this.addRow(this.linkHeader);
    }

    protected void updateHeader(MaltegoLink link) {
        this.createLinkHeader(link);
        if (!this.properties.addAll((Collection<PropertyDescriptor>)link.getProperties())) {
            return;
        }
        for (PropertyDescriptor property : this.properties) {
            if (this.linkHeader.contains(property.getName())) continue;
            this.linkHeader.add(property.getName());
        }
    }

    protected Data readLink(Reader linkReader) {
        List<String> row = this.gotoLinkDataRow(linkReader);
        if (row.isEmpty()) {
            return null;
        }
        LinkID linkId = LinkID.parse((String)row.get(this.offset));
        EntityID sourceId = EntityID.parse((String)row.get(this.offset + 1));
        EntityID targetId = EntityID.parse((String)row.get(this.offset + 2));
        MaltegoLink link = this.linkFactory().createInstance(MaltegoLinkSpec.getManualSpec(), linkId, true);
        Data data = new Data(sourceId, link, targetId);
        this.setLinkPropertyData(link, linkReader.propertyNames, row);
        return data;
    }

    private List<String> gotoLinkDataRow(Reader linkReader) {
        while (linkReader.rowIterator.hasNext()) {
            List<String> row = linkReader.rowIterator.next();
            if (row.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (this.offset > 0) {
                String col = row.get(0);
                if (col == null || !col.isEmpty()) continue;
                return row;
            }
            return row;
        }
        return Collections.EMPTY_LIST;
    }

    protected void setLinkPropertyData(MaltegoLink link, List<String> propertyNames, List<String> values) {
        PropertyDescriptorCollection properties = link.getProperties();
        for (int column = this.offset + 3; column < propertyNames.size() && column < values.size(); ++column) {
            String name;
            String value = values.get(column);
            if (value == null || value.isEmpty() || (name = propertyNames.get(column)) == null || name.isEmpty()) continue;
            PropertyDescriptor property = properties.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
            if (property == null) {
                property = new PropertyDescriptor(String.class, name);
                properties.add(property);
            }
            Object data = Converter.convertFrom((String)value, (Class)property.getType());
            link.setValue(property, data);
        }
    }

    protected class Reader
    implements Iterator<Data> {
        protected Iterator<List<String>> rowIterator;
        protected List<String> propertyNames;

        protected Reader() {
            this.rowIterator = LinkTableFormatter.this.rowIterator();
            this.propertyNames = this.readHeader();
        }

        protected List<String> readHeader() {
            while (this.rowIterator.hasNext()) {
                List<String> row = this.rowIterator.next();
                LinkTableFormatter.this.offset = row.indexOf(LINK_START_ID);
                if (LinkTableFormatter.this.offset < 0) continue;
                return row;
            }
            LinkTableFormatter.this.offset = 0;
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public Data next() {
            return LinkTableFormatter.this.readLink(this);
        }
    }

    public static class Data {
        private final MaltegoLink link;
        private final EntityID sourceID;
        private final EntityID targetID;

        public Data(EntityID sourceID, MaltegoLink link, EntityID targetID) {
            this.sourceID = sourceID;
            this.targetID = targetID;
            this.link = link;
        }

        public MaltegoLink getLink() {
            return this.link;
        }

        public EntityID getSourceID() {
            return this.sourceID;
        }

        public EntityID getTargetID() {
            return this.targetID;
        }
    }
}

