/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.api.proxy;

import com.paterva.maltego.certificates.BlacklistedCertificateException;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.api.proxy.HttpProxy;
import com.paterva.maltego.transform.protocol.api.proxy.HttpProxyExceptionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DefaultHttpProxy
extends HttpProxy {
    private static final Logger LOG = Logger.getLogger(DefaultHttpProxy.class.getName());
    private static final String API_KEY_HEADER = "Maltego-API-Key";
    private static final int REQUEST_TIME_OUT = 10000;

    public DefaultHttpProxy(String transformApp) {
        super(transformApp, "2.0");
    }

    public Map<String, String> getSeedInfo(boolean httpsOnly, String maltegoApiKey) throws ProxyException, CertificateNeedValidationException, BlacklistedCertificateException, NoTrustedCertificateChainFoundException, GeneralSecurityException, IOException {
        Map<String, List<String>> responseHeaders = this.doOptions(this.transformApp, maltegoApiKey, httpsOnly);
        return responseHeaders.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
    }

    private Map<String, List<String>> doOptions(String url, String key, boolean httpsOnly) throws CertificateNeedValidationException, BlacklistedCertificateException, NoTrustedCertificateChainFoundException, GeneralSecurityException, IOException {
        HttpAgent agent = null;
        try {
            String cfAccessToken;
            LOG.log(Level.FINE, "Server OPTIONS from {0}", url);
            agent = new HttpAgent(new URL(url));
            agent.setRequestHeader("maltego-protocol-version", "3.1");
            agent.setConnectTimeout(10000);
            agent.setReadTimeout(10000);
            DefaultHttpProxy.createExceptionFromCertificateActionIfPresent(agent, url, httpsOnly);
            String accessToken = LicenseManager.A().H(url);
            agent.setAccessToken(accessToken);
            if (accessToken == null && key != null) {
                agent.setRequestHeader(API_KEY_HEADER, key);
            }
            if ((cfAccessToken = DefaultHttpProxy.getCloudflareAccessToken()) != null && !cfAccessToken.isEmpty()) {
                agent.setRequestHeader("cf-access-token", cfAccessToken);
            }
            agent.doOptions();
            String content = agent.getContentAsString();
            Map headers = agent.getResponseHeaders();
            HttpProxyExceptionUtils.parseForPotentialResponseErrors(headers, content);
            Map map = headers;
            return map;
        }
        catch (CertificateNeedValidationException ex) {
            throw ex;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
    }
}

