/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;

final class FixedModule
extends Module {
    private Properties localizedProps;
    private final Manifest manifest;

    public FixedModule(ModuleManager mgr, Events ev, Manifest manifest, Object history, ClassLoader classloader, boolean autoload, boolean eager) throws InvalidException {
        super(mgr, ev, history, classloader, autoload, eager);
        this.manifest = manifest;
        this.loadLocalizedPropsClasspath();
        this.parseManifest();
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    public Object getLocalizedAttribute(String attr) {
        int idx;
        String locb = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean usingLoader = false;
        if (locb != null) {
            String val;
            if (this.classloader != null) {
                if (locb.endsWith(".properties")) {
                    usingLoader = true;
                    String basename = locb.substring(0, locb.length() - 11).replace('/', '.');
                    try {
                        ResourceBundle bundle = NbBundle.getBundle((String)basename, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return bundle.getString(attr);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException mre) {
                        Util.err.log(Level.WARNING, null, mre);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + locb);
                }
            }
            if (!usingLoader && this.localizedProps != null && (val = this.localizedProps.getProperty(attr)) != null) {
                return val;
            }
        }
        if ((idx = attr.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(attr));
        }
        String section = attr.substring(0, idx);
        String realAttr = attr.substring(idx + 1);
        Attributes attrs = this.getManifest().getAttributes(section);
        if (attrs != null) {
            return NbBundle.getLocalizedValue((Attributes)attrs, (Attributes.Name)new Attributes.Name(realAttr));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    private void loadLocalizedPropsClasspath() throws InvalidException {
        Attributes attr = this.manifest.getMainAttributes();
        String locbundle = attr.getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            Util.err.fine("Localized props in " + locbundle + " for " + attr.getValue("OpenIDE-Module"));
            try {
                String ext;
                String name;
                int idx = locbundle.lastIndexOf(46);
                if (idx == -1) {
                    name = locbundle;
                    ext = "";
                } else {
                    name = locbundle.substring(0, idx);
                    ext = locbundle.substring(idx);
                }
                ArrayList suffixes = new ArrayList(10);
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    suffixes.add(it.next());
                }
                Collections.reverse(suffixes);
                for (String suffix : suffixes) {
                    String resource = name + suffix + ext;
                    InputStream is = this.classloader.getResourceAsStream(resource);
                    if (is == null) continue;
                    Util.err.fine("Found " + resource);
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    this.localizedProps.load(is);
                }
                if (this.localizedProps == null) {
                    throw new IOException("Could not find localizing bundle: " + locbundle);
                }
            }
            catch (IOException ioe) {
                throw (InvalidException)new InvalidException(ioe.toString()).initCause(ioe);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        return Collections.emptyList();
    }

    @Override
    public void setReloadable(boolean r) {
        throw new IllegalStateException();
    }

    @Override
    public void reload() throws IOException {
        throw new IOException("Fixed module cannot be reloaded!");
    }

    @Override
    protected void classLoaderUp(Set<Module> parents) throws IOException {
    }

    @Override
    protected void classLoaderDown() {
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public String toString() {
        String s = "FixedModule:" + this.getCodeNameBase();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    @Override
    void refineDependencies(Set<Dependency> dependencies) {
    }
}

