/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.imex.EntityConfig;
import com.paterva.maltego.entity.manager.imex.EntityExistInfo;
import com.paterva.maltego.entity.manager.imex.EntityImporter;
import com.paterva.maltego.entity.manager.imex.SelectableCategory;
import com.paterva.maltego.entity.manager.imex.SelectableEntitySpec;
import com.paterva.maltego.entity.registry.DefaultEntityRegistry;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openide.filesystems.FileObject;

public class EntityConfigImporter
extends ConfigImporter {
    private final String DEFAULT_FOLDER = "Miscellaneous";

    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        EntityImporter entityImporter = new EntityImporter();
        List<String> categories = entityImporter.readCategories(reader);
        List<MaltegoEntitySpec> specs = entityImporter.readEntities(reader);
        return this.createConfig(categories, specs);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        DefaultEntityRegistry registry = new DefaultEntityRegistry(configRoot);
        List<String> categories = Arrays.asList(registry.allCategories());
        ArrayList<MaltegoEntitySpec> specs = new ArrayList<MaltegoEntitySpec>(registry.getAll());
        return this.createConfig(categories, specs);
    }

    private Config createConfig(List<String> savedCategories, List<MaltegoEntitySpec> entitiesAll) {
        EntityExistInfo entityExistInfo = new EntityExistInfo();
        ArrayList<SelectableCategory> selectables = new ArrayList<SelectableCategory>();
        HashSet<String> categoryNames = new HashSet<String>(savedCategories);
        for (MaltegoEntitySpec maltegoEntitySpec : entitiesAll) {
            categoryNames.add(maltegoEntitySpec.getDefaultCategory());
        }
        for (String categoryName : categoryNames) {
            ArrayList<SelectableEntitySpec> selectableEntities = new ArrayList<SelectableEntitySpec>();
            boolean selectCategory = false;
            for (MaltegoEntitySpec maltegoEntitySpec : entitiesAll) {
                if ((categoryName == null || !categoryName.equals(maltegoEntitySpec.getDefaultCategory())) && (categoryName != null || maltegoEntitySpec.getDefaultCategory() != null)) continue;
                boolean selectEntity = !entityExistInfo.exist(maltegoEntitySpec);
                selectableEntities.add(new SelectableEntitySpec(maltegoEntitySpec, selectEntity));
                selectCategory = selectCategory || selectEntity;
            }
            selectCategory = selectableEntities.isEmpty() ? true : selectCategory;
            selectables.add(new SelectableCategory(selectableEntities, categoryName != null ? categoryName : "Miscellaneous", selectCategory));
        }
        if (selectables.size() > 0) {
            return new EntityConfig(selectables);
        }
        return null;
    }

    public int applyConfig(Config config) {
        EntityConfig entityConfig = (EntityConfig)config;
        List<MaltegoEntitySpec> selected = entityConfig.getSelectedEntities();
        EntityImporter entityImporter = new EntityImporter();
        entityImporter.applyEntities(selected, DiscoveryMergingRules.EntityRule.REPLACE);
        return selected.size();
    }
}

