/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.imex.EntityConfigNode;
import com.paterva.maltego.entity.manager.imex.EntityExistInfo;
import com.paterva.maltego.entity.manager.imex.SelectableCategory;
import com.paterva.maltego.entity.manager.imex.SelectableEntitySpec;
import com.paterva.maltego.importexport.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.nodes.Node;

class EntityConfig
implements Config {
    private final ArrayList<SelectableCategory> _categories;

    public EntityConfig(String[] categoryNames, Collection<MaltegoEntitySpec> entities) {
        ArrayList<SelectableCategory> selectableCategories = new ArrayList<SelectableCategory>(categoryNames.length);
        for (String categoryName : categoryNames) {
            if (categoryName.equals("RecentlyUsed")) continue;
            ArrayList<SelectableEntitySpec> categoryEntities = new ArrayList<SelectableEntitySpec>();
            for (MaltegoEntitySpec entity : entities) {
                if (!categoryName.equals(entity.getDefaultCategory())) continue;
                SelectableEntitySpec selectableEntity = new SelectableEntitySpec(entity, true);
                categoryEntities.add(selectableEntity);
            }
            selectableCategories.add(new SelectableCategory(categoryEntities, categoryName, true));
        }
        this._categories = selectableCategories;
    }

    public EntityConfig(ArrayList<SelectableCategory> categories) {
        this._categories = categories;
    }

    public ArrayList<SelectableCategory> getSelectables() {
        return this._categories;
    }

    public List<SelectableEntitySpec> getSelectableEntities() {
        ArrayList<SelectableEntitySpec> entities = new ArrayList<SelectableEntitySpec>();
        for (SelectableCategory selectableCategory : this._categories) {
            entities.addAll(selectableCategory);
        }
        return entities;
    }

    public List<String> getSelectedCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (SelectableCategory selectableCategory : this._categories) {
            if (!selectableCategory.isSelected()) continue;
            categories.add(selectableCategory.getName());
        }
        return categories;
    }

    public List<MaltegoEntitySpec> getSelectedEntities() {
        ArrayList<MaltegoEntitySpec> entities = new ArrayList<MaltegoEntitySpec>();
        for (SelectableCategory selectableCategory : this._categories) {
            if (!selectableCategory.isSelected()) continue;
            for (SelectableEntitySpec selectableEntity : selectableCategory) {
                if (!selectableEntity.isSelected()) continue;
                entities.add(selectableEntity.getEntitySpec());
            }
        }
        return entities;
    }

    public Node getConfigNode(boolean showExistInfo) {
        EntityExistInfo existInfo = showExistInfo ? new EntityExistInfo() : null;
        return new EntityConfigNode(this, existInfo);
    }

    public int getPriority() {
        return 20;
    }
}

