/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.actions;

import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.SpecAction;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.awt.HtmlBrowser;

public class BrowseUrlsAction
extends SpecAction {
    private static final Logger LOG = Logger.getLogger(BrowseUrlsAction.class.getName());

    public String getTypeName() {
        return "maltego.spec.action.type.browse-urls";
    }

    public boolean isEnabledFor(SpecRegistry registry, MaltegoPart part, String config) {
        return !this.generatePartURLs(part).isEmpty();
    }

    public void perform(SpecRegistry registry, MaltegoPart part, String config) {
        List<URL> urls = this.generatePartURLs(part);
        for (URL url : urls) {
            if (FileUtilities.isRemoteFileURL((URL)url)) continue;
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private List<URL> generatePartURLs(MaltegoPart part) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (PropertyDescriptor pd : part.getProperties()) {
            Object value;
            if (FastURL.class.equals((Object)pd.getType())) {
                value = (FastURL)part.getValue(pd);
                if (value == null) continue;
                try {
                    urls.add(value.getURL());
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.WARNING, "Failed creating valid URL from string: {0}", ex.toString());
                }
                continue;
            }
            if (!String.class.equals((Object)pd.getType()) || (value = (String)part.getValue(pd)) == null) continue;
            if (((String)value).startsWith("www.")) {
                value = "http://" + (String)value;
            }
            try {
                URL url = new URL((String)value);
                urls.add(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return urls;
    }
}

