/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.EntityQuickFilter;
import com.paterva.maltego.entity.manager.EntityRegistryTableModel;
import com.paterva.maltego.entity.manager.forms.EditEntityTypeAction;
import com.paterva.maltego.entity.manager.forms.NewEntityTypeBasicAction;
import com.paterva.maltego.entity.manager.imex.ExportEntitiesAction;
import com.paterva.maltego.entity.manager.imex.ImportEntitiesAction;
import com.paterva.maltego.entity.manager.palette.FavouriteEntities;
import com.paterva.maltego.entity.registry.RestoreEntitiesAction;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.outline.TableSearchPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.util.ui.table.ETableColumnSelectionDecorator;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class EntityManagerForm
extends JPanel {
    private EntityRegistry _registry;
    private final EntityRegistryTableModel _model;
    private JButton _exportButton;
    private JButton _importButton;
    private JButton _newButton;
    private JButton _restoreButton;
    private ETable _table;
    private TableSearchPanel _tableSearchPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;

    public EntityManagerForm() {
        this((EntityRegistry)null);
    }

    public EntityManagerForm(EntityRegistry entities) {
        this._registry = entities;
        this.initComponents();
        this._restoreButton.setVisible("true".equals(System.getProperty("maltego.entities.can_restore", "false")));
        this._model = new EntityRegistryTableModel(this.registry());
        this._table.setModel((TableModel)((Object)this._model));
        EditableTableDecorator decorator = new EditableTableDecorator();
        decorator.addEditDelete((JTable)this._table, new TableButtonListener(){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(TableButtonEvent evt) {
                void var6_8;
                int[] selectedRows = evt.getSelectedRows();
                ArrayList<Object> specs = new ArrayList<Object>(selectedRows.length);
                int[] nArray = selectedRows;
                int n = nArray.length;
                boolean bl = false;
                while (var6_8 < n) {
                    int i = nArray[var6_8];
                    specs.add(EntityManagerForm.this._model.getRow(EntityManagerForm.this._table.convertRowIndexToModel(i)));
                    ++var6_8;
                }
                String message = specs.size() > 1 ? "Would you like to delete these " + specs.size() + " selected entities?" + StringUtilities.newLine() + "This might affect the way your graphs are displayed." : "Would you like to delete the " + ((MaltegoEntitySpec)specs.get(0)).getDisplayName() + " entity?" + StringUtilities.newLine() + "This might affect the way your graphs are displayed.";
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, "Delete entity?", 1)) == NotifyDescriptor.YES_OPTION) {
                    for (MaltegoEntitySpec maltegoEntitySpec : specs) {
                        String typeName = maltegoEntitySpec.getTypeName();
                        FavouriteEntities.removeFavoriteEntity(typeName);
                        EntityManagerForm.this.registry().remove(typeName);
                    }
                }
            }
        }, new TableButtonListener(){

            public void actionPerformed(TableButtonEvent evt) {
                MaltegoEntitySpec spec = (MaltegoEntitySpec)EntityManagerForm.this._model.getRow(EntityManagerForm.this._table.convertRowIndexToModel(evt.getSelectedRows()[0]));
                ((EditEntityTypeAction)SystemAction.get(EditEntityTypeAction.class)).edit(spec);
            }
        });
        TableColumnModel columns = this._table.getColumnModel();
        TableColumn col0 = columns.getColumn(0);
        col0.setPreferredWidth(20);
        ETableColumnSelectionDecorator selectionDecorator = new ETableColumnSelectionDecorator();
        selectionDecorator.makeSelectable(this._table, EntityRegistryTableModel.Columns, new boolean[]{true, true, true, false, false, false}, new String[]{"Image", null, null, null, null, null});
        this._table.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        PaddedTableCellRenderer paddedRenderer = new PaddedTableCellRenderer();
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)paddedRenderer);
        this._table.setAutoCreateColumnsFromModel(false);
        this._tableSearchPanel.setTable(this._table);
        this._tableSearchPanel.setMaximumSize(new Dimension(120, 30));
        this._tableSearchPanel.setFilter((TextQuickFilter)new EntityQuickFilter(this._model), 1);
    }

    private EntityRegistry registry() {
        if (this._registry == null) {
            return EntityRegistry.getDefault();
        }
        return this._registry;
    }

    public ETable getEntityTable() {
        return this._table;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._newButton = new JButton();
        this._importButton = new JButton();
        this._exportButton = new JButton();
        this._restoreButton = new JButton();
        this.jPanel3 = new JPanel();
        this._tableSearchPanel = new TableSearchPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._table = new EntityETable();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this._newButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._newButton.text"));
        this._newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityManagerForm.this._newButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 10, 0);
        this.jPanel1.add((Component)this._newButton, gridBagConstraints);
        this._importButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._importButton.text"));
        this._importButton.setMaximumSize(new Dimension(84, 23));
        this._importButton.setMinimumSize(new Dimension(84, 23));
        this._importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityManagerForm.this._importButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel1.add((Component)this._importButton, gridBagConstraints);
        this._exportButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._exportButton.text"));
        this._exportButton.setMaximumSize(new Dimension(84, 23));
        this._exportButton.setMinimumSize(new Dimension(84, 23));
        this._exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityManagerForm.this._exportButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 10, 0);
        this.jPanel1.add((Component)this._exportButton, gridBagConstraints);
        this._restoreButton.setText(NbBundle.getMessage(EntityManagerForm.class, (String)"EntityManagerForm._restoreButton.text"));
        this._restoreButton.setMaximumSize(new Dimension(84, 23));
        this._restoreButton.setMinimumSize(new Dimension(84, 23));
        this._restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityManagerForm.this._restoreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 10, 0);
        this.jPanel1.add((Component)this._restoreButton, gridBagConstraints);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 10, 10);
        this.jPanel1.add((Component)this._tableSearchPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._table.setRowHeight(20);
        this.jScrollPane1.setViewportView((Component)this._table);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void _newButtonActionPerformed(ActionEvent evt) {
        ((NewEntityTypeBasicAction)SystemAction.get(NewEntityTypeBasicAction.class)).performAction();
    }

    private void _importButtonActionPerformed(ActionEvent evt) {
        ((ImportEntitiesAction)SystemAction.get(ImportEntitiesAction.class)).perform();
    }

    private void _exportButtonActionPerformed(ActionEvent evt) {
        ((ExportEntitiesAction)SystemAction.get(ExportEntitiesAction.class)).perform();
    }

    private void _restoreButtonActionPerformed(ActionEvent evt) {
        String title = "Restore Default Entities?";
        String msg = "Are you sure you want to restore all the default entities? Note that custom entities will not be affected but modification to the default entities will be reverted.";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title, 2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            ((RestoreEntitiesAction)SystemAction.get(RestoreEntitiesAction.class)).perform(true);
        }
    }

    private static class EntityETable
    extends ETable {
        private EntityETable() {
        }

        protected boolean acceptByQuickFilter(TableModel model, int row) {
            int quickFilterColumn = this.getQuickFilterColumn();
            Object quickFilterObject = this.getQuickFilterObject();
            if (quickFilterColumn == -1 || quickFilterObject == null) {
                return true;
            }
            Object value = model.getValueAt(row, quickFilterColumn);
            value = this.transformValue(value);
            if (quickFilterObject instanceof EntityQuickFilter) {
                EntityQuickFilter filter = (EntityQuickFilter)quickFilterObject;
                return filter.accept(model, row, quickFilterColumn, value);
            }
            if (value == null) {
                return false;
            }
            return value.equals(quickFilterObject);
        }
    }
}

