/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyForwarder;
import org.xlightweb.BodyType;
import org.xlightweb.BodylessMessageWriter;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.FullMessageChunkedWriter;
import org.xlightweb.FullMessageWriter;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.HttpProtocolHandlerClientSide;
import org.xlightweb.HttpProtocolHandlerServerSide;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpDisconnectHandler;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IMessageWriter;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.RequestHandlerInfo;
import org.xlightweb.ResponseHandlerInfo;
import org.xlightweb.SimpleMessageWriter;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.IDestroyable;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpConnection
implements IHttpConnection,
IDestroyable {
    private static final Logger LOG = Logger.getLogger(AbstractHttpConnection.class.getName());
    private static final NullMessageWriter NULL_BODYWRITER = new NullMessageWriter();
    private static final String DEFAULT_MAX_WRITE_BUFFER_SIZE = "65536";
    private static final int MAX_WRITEBUFFER_SIZE = Integer.parseInt(System.getProperty("org.xlightweb.connection.max_write_buffer_size", "65536"));
    private static final Timer TIMER = new Timer("xHttpTimer", true);
    private final INonBlockingConnection tcpConnection;
    private final AtomicBoolean isPersistent = new AtomicBoolean(true);
    private final AtomicReference<BodyDataSink> bodyDataSink = new AtomicReference();
    private Object attachment;
    private final DataHandler dataHandler = new DataHandler();
    private final AbstractHttpProtocolHandler protocolHandler;
    private final Set<IHttpConnectionHandler> connectionHandlers = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean isDisconnected = new AtomicBoolean(false);
    private final MultimodeExecutor multimodeExcutor = new MultimodeExecutor();
    private long bodyDataReceiveTimeoutMillis = Long.MAX_VALUE;
    private long lastTimeDataWritten = System.currentTimeMillis();
    private long lastTimeHeaderReceivedMillis = System.currentTimeMillis();
    private long lastTimeMessageTailReceivedMillis = System.currentTimeMillis();
    private long lastTimeDataReceivedMillis = System.currentTimeMillis();
    private final AtomicInteger countSuspendReceiving = new AtomicInteger(0);
    private final AtomicInteger countResumeReceiving = new AtomicInteger(0);
    private final AtomicInteger countReceivedMessages = new AtomicInteger(0);
    private final AtomicInteger countSentMessages = new AtomicInteger(0);
    private int countSendBytes = 0;
    private int countReceivedBytes = 0;

    protected AbstractHttpConnection(INonBlockingConnection tcpConnection, boolean isClientSideConnection) throws IOException {
        this.tcpConnection = tcpConnection;
        this.protocolHandler = isClientSideConnection ? new HttpProtocolHandlerClientSide() : new HttpProtocolHandlerServerSide();
        tcpConnection.setMaxReadBufferThreshold(0x7FFFFFFE);
        tcpConnection.setAutoflush(false);
        tcpConnection.setAttachment((Object)this);
    }

    protected static String getBodyType(NonBlockingBodyDataSource body) {
        return body.getBodyType().toString();
    }

    protected final void init() throws IOException {
        this.tcpConnection.setHandler((IHandler)this.dataHandler);
        this.onConnect();
    }

    protected final int incCountMessageReceived() {
        return this.countReceivedMessages.incrementAndGet();
    }

    protected int getCountMessagesReceived() {
        return this.countReceivedMessages.get();
    }

    protected int getCountSendBytes() {
        return this.countSendBytes;
    }

    protected int getCountReceivedBytes() {
        return this.countReceivedBytes;
    }

    protected final int incCountMessageSent() {
        return this.countSentMessages.incrementAndGet();
    }

    protected int getCountMessagesSent() {
        return this.countSentMessages.get();
    }

    protected int getCountSuspendReceiving() {
        return this.countSuspendReceiving.get();
    }

    protected int getCountResumeReceiving() {
        return this.countResumeReceiving.get();
    }

    protected final void setLastTimeDataReceivedMillis(long time) {
        this.lastTimeDataReceivedMillis = time;
    }

    protected long getLastTimeDataReceivedMillis() {
        return this.lastTimeDataReceivedMillis;
    }

    protected final void setLastTimeMessageTailReceivedMillis(long time) {
        this.lastTimeMessageTailReceivedMillis = time;
    }

    protected final long getLastTimeMessageTailReceivedMillis() {
        return this.lastTimeMessageTailReceivedMillis;
    }

    protected final void setLastTimeHeaderReceivedMillis(long time) {
        this.lastTimeHeaderReceivedMillis = time;
    }

    protected final long getLastTimeHeaderReceivedMillis() {
        return this.lastTimeHeaderReceivedMillis;
    }

    protected final long getLastTimeWritten() {
        return this.lastTimeDataWritten;
    }

    protected final IMultimodeExecutor getExecutor() {
        return this.multimodeExcutor;
    }

    @Override
    public INonBlockingConnection getUnderlyingTcpConnection() {
        return this.tcpConnection;
    }

    @Override
    public final long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis;
    }

    @Override
    public final void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        if (connectionHandler == null) {
            throw new NullPointerException("conection handler has to be set");
        }
        this.connectionHandlers.add(connectionHandler);
        if (this.isDisconnected.get()) {
            this.callOnDisconnect(connectionHandler, HttpUtils.getHttpConnectionHandlerInfo(connectionHandler));
        }
    }

    @Override
    public final void removeConnectionHandler(IHttpConnectionHandler connectionHandler) {
        this.connectionHandlers.remove(connectionHandler);
    }

    @Override
    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
    }

    public final void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public final long getConnectionTimeoutMillis() {
        return this.tcpConnection.getConnectionTimeoutMillis();
    }

    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.tcpConnection.setConnectionTimeoutMillis(timeoutMillis);
    }

    public final long getRemainingMillisToConnectionTimeout() {
        return this.tcpConnection.getRemainingMillisToConnectionTimeout();
    }

    public final long getIdleTimeoutMillis() {
        return this.tcpConnection.getIdleTimeoutMillis();
    }

    public final void setIdleTimeoutMillis(long timeoutInMillis) {
        this.tcpConnection.setIdleTimeoutMillis(timeoutInMillis);
    }

    public final long getRemainingMillisToIdleTimeout() {
        return this.tcpConnection.getRemainingMillisToIdleTimeout();
    }

    public final Map<String, Class> getOptions() {
        return this.tcpConnection.getOptions();
    }

    public final Object getOption(String name) throws IOException {
        return this.tcpConnection.getOption(name);
    }

    public final void setOption(String name, Object value) throws IOException {
        this.tcpConnection.setOption(name, value);
    }

    public final InetAddress getLocalAddress() {
        return this.tcpConnection.getLocalAddress();
    }

    public final int getLocalPort() {
        return this.tcpConnection.getLocalPort();
    }

    public final InetAddress getRemoteAddress() {
        return this.tcpConnection.getRemoteAddress();
    }

    public final int getRemotePort() {
        return this.tcpConnection.getRemotePort();
    }

    @Override
    public final void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
        this.tcpConnection.setWriteTransferRate(bytesPerSecond);
    }

    @Override
    public final void setFlushmode(IConnection.FlushMode flushmode) {
        this.tcpConnection.setFlushmode(flushmode);
    }

    final IConnection.FlushMode getFlushmode() {
        return this.tcpConnection.getFlushmode();
    }

    @Override
    public final Executor getWorkerpool() {
        return this.tcpConnection.getWorkerpool();
    }

    public void setWorkerpool(Executor workerpool) {
        this.tcpConnection.setWorkerpool(workerpool);
    }

    @Override
    public void activateSecuredMode() throws IOException {
        this.tcpConnection.activateSecuredMode();
    }

    @Override
    public final boolean isSecure() {
        return this.tcpConnection.isSecure();
    }

    @Override
    public final boolean isPersistent() {
        return this.isPersistent.get();
    }

    protected final void setPersistent(boolean persistent) {
        this.isPersistent.set(persistent);
    }

    protected final boolean getPersistent() {
        return this.isPersistent.get();
    }

    public final String getId() {
        try {
            return this.tcpConnection.getId();
        }
        catch (Throwable t) {
            return "<unknown>";
        }
    }

    public final boolean isOpen() {
        return this.tcpConnection.isOpen();
    }

    public final void close() throws IOException {
        block4: {
            try {
                this.releaseResources();
                if (this.isReuseable()) {
                    this.tcpConnection.close();
                } else {
                    NonBlockingConnectionPool.destroy((INonBlockingConnection)this.tcpConnection);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured by closing htttp connection " + this.getId() + " " + DataConverter.toString((Throwable)e));
            }
        }
    }

    protected final void closeSilence() {
        block5: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + ioe.toString());
                }
                try {
                    NonBlockingConnectionPool.destroy((INonBlockingConnection)this.tcpConnection);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + e.toString());
                }
            }
        }
    }

    private void releaseResources() {
        BodyDataSink bds = this.bodyDataSink.get();
        if (bds != null) {
            this.bodyDataSink.set(null);
            bds.onUnderlyingHttpConnectionClosed();
        }
    }

    private boolean isReuseable() {
        return this.isPersistent.get() && !this.isReceivingSuspended();
    }

    public void destroy() {
        block2: {
            this.isPersistent.set(false);
            this.releaseResources();
            try {
                NonBlockingConnectionPool.destroy((INonBlockingConnection)this.tcpConnection);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by destroying htttp connection " + this.getId() + " " + ioe.toString());
            }
        }
    }

    @Override
    public final void suspendReceiving() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("suspend receving");
        }
        this.tcpConnection.suspendReceiving();
        this.countSuspendReceiving.incrementAndGet();
    }

    @Override
    public final boolean isReceivingSuspended() {
        return this.tcpConnection.isReceivingSuspended();
    }

    @Override
    public final void resumeReceiving() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] resume receving");
        }
        this.tcpConnection.resumeReceiving();
        this.countResumeReceiving.incrementAndGet();
    }

    final void setBodyDataSink(BodyDataSink bodyChannel) {
        this.bodyDataSink.set(bodyChannel);
    }

    final boolean removeBodyDataSink(BodyDataSink bodyChannel) {
        BodyDataSink bds = this.bodyDataSink.get();
        if (bds != null && bds == bodyChannel) {
            this.bodyDataSink.set(null);
            return true;
        }
        return false;
    }

    final void flush() throws IOException {
        this.tcpConnection.flush();
    }

    final int write(String txt) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] TCP write: " + txt);
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        int size = this.tcpConnection.write(txt);
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    final long write(ByteBuffer[] buffer, IWriteCompletionHandler completionHandler) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            ByteBuffer[] bufs = new ByteBuffer[buffer.length];
            for (int i = 0; i < buffer.length; ++i) {
                bufs[i] = buffer[i].duplicate();
            }
            LOG.fine("[" + this.getId() + "] TCP write: " + DataConverter.toString((ByteBuffer[])bufs));
        }
        int size = 0;
        if (completionHandler != null) {
            for (ByteBuffer byteBuffer : buffer) {
                size += byteBuffer.remaining();
            }
            this.tcpConnection.write(buffer, completionHandler);
        } else {
            size = (int)this.tcpConnection.write(buffer);
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    protected abstract IMessageHandler getMessageHandler();

    protected void onProtocolException(Exception ex) {
        this.destroy();
    }

    protected void onConnect() throws IOException {
        for (final IHttpConnectionHandler connectionHandler : this.connectionHandlers) {
            HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo = HttpUtils.getHttpConnectionHandlerInfo(connectionHandler);
            if (!connectionHandlerInfo.isConnectHandler()) continue;
            Runnable task = new Runnable(){

                public void run() {
                    try {
                        ((IHttpConnectHandler)connectionHandler).onConnect(AbstractHttpConnection.this);
                    }
                    catch (IOException ioe) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + AbstractHttpConnection.this.getId() + "] error occured by performing onConnect on " + connectionHandler + " reason: " + ioe.toString());
                        }
                        AbstractHttpConnection.this.destroy();
                    }
                }
            };
            if (connectionHandlerInfo.isConnectHandlerMultithreaded()) {
                this.multimodeExcutor.processMultithreaded(task);
                continue;
            }
            this.multimodeExcutor.processNonthreaded(task);
        }
    }

    protected void onDisconnect() {
        block4: {
            try {
                if (!this.isDisconnected.getAndSet(true)) {
                    this.releaseResources();
                    for (IHttpConnectionHandler connectionHandler : this.connectionHandlers) {
                        HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo = HttpUtils.getHttpConnectionHandlerInfo(connectionHandler);
                        if (!connectionHandlerInfo.isDisconnectHandler()) continue;
                        this.callOnDisconnect(connectionHandler, connectionHandlerInfo);
                    }
                    this.connectionHandlers.clear();
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("[" + this.getId() + "] error occured by closing http connection " + DataConverter.toString((Throwable)t));
            }
        }
    }

    private void callOnDisconnect(final IHttpConnectionHandler connectionHandler, HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo) {
        Runnable task = new Runnable(){

            public void run() {
                try {
                    ((IHttpDisconnectHandler)connectionHandler).onDisconnect(AbstractHttpConnection.this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + AbstractHttpConnection.this.getId() + "] error occured by performing ondisconnect on " + connectionHandler + " reason: " + ioe.toString());
                    }
                    AbstractHttpConnection.this.destroy();
                }
            }
        };
        if (connectionHandlerInfo.isDisconnectHandlerMultithreaded()) {
            this.multimodeExcutor.processMultithreaded(task);
        } else {
            this.multimodeExcutor.processNonthreaded(task);
        }
    }

    protected void onConnectionTimeout() throws IOException {
        this.close();
    }

    protected void onIdleTimeout() throws IOException {
        this.close();
    }

    protected final BodyDataSink writeMessage(IHttpHeader header, boolean destroyOnClose) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        if (AbstractHttpConnection.isChunkedTransferEncoding(header)) {
            return new BodyDataSink(this, this.getExecutor(), new FullMessageChunkedWriter(this, destroyOnClose, header), header.getCharacterEncoding());
        }
        int contentLength = header.getContentLength();
        if (contentLength != -1) {
            return this.writeMessage(header, destroyOnClose, contentLength);
        }
        if (header.getConnection() != null && header.getConnection().equalsIgnoreCase("close")) {
            this.setPersistent(false);
            return new BodyDataSink(this, this.getExecutor(), new SimpleMessageWriter(this, destroyOnClose, header), header.getCharacterEncoding());
        }
        if (header.getContentType() != null) {
            this.setPersistent(false);
            return new BodyDataSink(this, this.getExecutor(), new SimpleMessageWriter(this, destroyOnClose, header), header.getCharacterEncoding());
        }
        return new BodyDataSink(this, this.getExecutor(), new BodylessMessageWriter(this, destroyOnClose, header), header.getCharacterEncoding());
    }

    protected final BodyDataSink writeMessage(IHttpHeader header, boolean destroyOnClose, int length) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        if (length > 0) {
            return new BodyDataSink(this, this.getExecutor(), new FullMessageWriter(this, destroyOnClose, header, length), header.getCharacterEncoding());
        }
        header.removeHeader("Content-Type");
        return new BodyDataSink(this, this.getExecutor(), new BodylessMessageWriter(this, destroyOnClose, header), header.getCharacterEncoding());
    }

    protected final void writeMessage(IHttpMessage message, boolean destroyOnClose) throws IOException {
        BodyDataSink bodyDataSink = this.writeMessage(message.getMessageHeader(), destroyOnClose);
        NonBlockingBodyDataSource bodyDataSource = message.getNonBlockingBody();
        if (message.getNonBlockingBody() == null) {
            IConnection.FlushMode flushMode = this.getFlushmode();
            this.setFlushmode(IConnection.FlushMode.ASYNC);
            this.write(message.getMessageHeader().toString() + "\r\n");
            this.flush();
            this.setFlushmode(flushMode);
            return;
        }
        bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
        bodyDataSink.setAutoflush(false);
        if (bodyDataSource.isComplete()) {
            int available;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] message body to sent is complete.writing all data to body data sink ");
            }
            if ((available = bodyDataSource.available()) > 0) {
                bodyDataSink.write(bodyDataSource.readByteBufferByLength(available));
            }
            bodyDataSink.close();
        } else {
            BodyForwarder forwarder = new BodyForwarder(bodyDataSource, bodyDataSink);
            bodyDataSource.setDataHandler(forwarder);
            bodyDataSink.flush();
        }
    }

    static boolean isChunkedTransferEncoding(IHttpHeader header) {
        String transferEncoding = header.getTransferEncoding();
        return transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked");
    }

    protected static RequestHandlerInfo getRequestHandlerInfo(IHttpRequestHandler requestHandler) {
        return HttpUtils.getHttpRequestHandlerInfo(requestHandler);
    }

    protected static void setUnderlyingResource(FutureResponseHandler responseHandler, IDestroyable detroyable) {
        responseHandler.setUnderlyingResource(detroyable);
    }

    protected static ResponseHandlerInfo getResponseHandlerInfo(IHttpResponseHandler responseHandler) {
        return HttpUtils.getHttpResponseHandlerInfo(responseHandler);
    }

    protected static boolean isAcceptingChunkedResponseBody(IHttpRequest request) {
        String protocolVersion = request.getProtocolVersion();
        if (protocolVersion.equals("1.1")) {
            return true;
        }
        int idx = protocolVersion.indexOf(".");
        int minor = Integer.parseInt(protocolVersion.substring(idx + 1, protocolVersion.length()));
        if (minor > 0) {
            return true;
        }
        int major = Integer.parseInt(protocolVersion.substring(0, idx));
        return major > 1;
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        TIMER.schedule(task, delay, period);
    }

    protected static final DataSourceSinkPair newBodyDataSourceSinkPair(AbstractHttpConnection connection, IMultimodeExecutor executor, String encoding) throws IOException {
        final NonBlockingBodyDataSource bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, encoding);
        IMessageWriter messageWriter = new IMessageWriter(){

            public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
                if (!bodyDataSource.isOpen()) {
                    throw new ClosedChannelException();
                }
                bodyDataSource.append(isContentImmutable, bodyData, completionHandler);
            }

            public void close() throws IOException {
                bodyDataSource.setComplete(true);
            }

            public void destroy() {
                bodyDataSource.destroy();
            }

            public boolean isNetworkEndpoint() {
                return false;
            }

            public int getPendingWriteDataSize() {
                return 0;
            }
        };
        final BodyDataSink bodyDataSink = new BodyDataSink(connection, executor, messageWriter, encoding);
        IBodyCloseListener closeListener = new IBodyCloseListener(){

            @Execution(value=0)
            public void onClose() throws IOException {
                bodyDataSink.close();
            }
        };
        bodyDataSource.addCloseListener(closeListener);
        return new DataSourceSinkPair(bodyDataSource, bodyDataSink);
    }

    protected static IHttpRequest newFormEncodedRequestWrapper(IHttpRequest request) throws IOException {
        return HttpUtils.newFormEncodedRequestWrapper(request);
    }

    protected final void setBodyCloseListener(BodyDataSink bodyDataSink, Runnable task) {
        bodyDataSink.addCloseListener(new BodyCloseListener(task));
    }

    protected final void setDestroyConnectionAfterReceived(NonBlockingBodyDataSource bodyDataSource, boolean isCloseConnectionAfterReceived) {
        bodyDataSource.setDestroyAfterReceived(isCloseConnectionAfterReceived);
    }

    protected final void setCloseConnectionAfterReceived(NonBlockingBodyDataSource bodyDataSource, boolean isCloseConnectionAfterReceived) {
        bodyDataSource.setCloseAfterReceived(isCloseConnectionAfterReceived);
    }

    protected final BodyDataSink newBufferedBodyDataSink(IBodyDataHandler bodyDataHandler, String encoding) throws IOException {
        return new BodyDataSink(this, this.getExecutor(), new MessageWriter(bodyDataHandler, encoding), encoding);
    }

    protected static int getMaxWriteBufferSize() {
        return MAX_WRITEBUFFER_SIZE;
    }

    protected static String generateErrorMessageHtml(int errorCode, String msg, String connectionId) {
        if (msg == null) {
            msg = HttpUtils.getReason(errorCode);
        }
        msg = msg.replace("\r", "<br/>");
        String txt = "<html>\r\n  <!-- This page is auto-generated by xLightweb (http://xLightweb.org) -->\r\n  <!-- id " + connectionId + " -->\r\n" + "  <!-- xLightweb/" + HttpUtils.getImplementationVersion() + " (xSocket/" + ConnectionUtils.getImplementationVersion() + ") -->\r\n" + "  <head>\r\n" + "    <title>Error " + errorCode + "</title>\r\n" + "    <meta http-equiv=\"cache-control\" content=\"no-cache\"/>" + "  </head>\r\n\r\n" + "  <body>\r\n" + "    <H1 style=\"color:#0a328c;font-size:1.5em;\">ERROR " + errorCode + "</H1>\r\n" + "    <p style=\"font-size:1.5em;\">" + msg + "</p>\r\n" + "    <p style=\"font-size:0.8em;\">" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date()) + "    xLightweb (" + HttpUtils.getImplementationVersion() + ")</p>\r\n" + "  <body>\r\n" + "</html>\r\n";
        return txt;
    }

    protected final BodyDataSink newEmtpyBodyDataSink() throws IOException {
        return new BodyDataSink(this, this.getExecutor(), NULL_BODYWRITER, "UTF-8");
    }

    private AbstractHttpProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    private static AbstractHttpConnection getHttpConnection(INonBlockingConnection tcpConnection) {
        return (AbstractHttpConnection)tcpConnection.getAttachment();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId() + " " + this.tcpConnection.getLocalAddress() + ":" + this.tcpConnection.getLocalPort() + " -> " + this.tcpConnection.getRemoteAddress() + ":" + this.tcpConnection.getRemotePort());
        if (!this.tcpConnection.isOpen()) {
            sb.append("  (closed)");
        }
        return sb.toString();
    }

    @Execution(value=0)
    private final class DataHandler
    implements IDataHandler,
    IConnectHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler {
        private final ComposedByteBuffer rawData = new ComposedByteBuffer();

        private DataHandler() {
        }

        public boolean onData(INonBlockingConnection connection) throws BufferUnderflowException {
            AbstractHttpConnection.this.lastTimeDataReceivedMillis = System.currentTimeMillis();
            if (connection.isOpen()) {
                AbstractHttpProtocolHandler protocolHandler = AbstractHttpConnection.getHttpConnection(connection).getProtocolHandler();
                try {
                    int available = connection.available();
                    if (available > 0) {
                        ByteBuffer[] data = connection.readByteBufferByLength(available);
                        if (LOG.isLoggable(Level.FINE)) {
                            ByteBuffer[] bufs = new ByteBuffer[data.length];
                            for (int i = 0; i < data.length; ++i) {
                                bufs[i] = data[i].duplicate();
                            }
                            LOG.fine("[" + AbstractHttpConnection.this.getId() + "] TCP read: " + DataConverter.toString((ByteBuffer[])bufs));
                        }
                        this.rawData.append(data);
                        do {
                            protocolHandler.onData(AbstractHttpConnection.this, connection, this.rawData);
                        } while (!this.rawData.isEmpty());
                        this.rawData.clear();
                    }
                    return true;
                }
                catch (ClosedChannelException cce) {
                    AbstractHttpConnection.this.setPersistent(false);
                    protocolHandler.onDisconnect();
                }
                catch (IOException ex) {
                    AbstractHttpConnection.this.setPersistent(false);
                    protocolHandler.onException(AbstractHttpConnection.this, ex, this.rawData);
                    AbstractHttpConnection.this.onProtocolException(ex);
                }
            }
            return true;
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + AbstractHttpConnection.this.getId() + "] disconnected");
            }
            AbstractHttpProtocolHandler protocolHandler = AbstractHttpConnection.getHttpConnection(connection).getProtocolHandler();
            protocolHandler.onDisconnect();
            AbstractHttpConnection.this.onDisconnect();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            AbstractHttpConnection.this.onConnectionTimeout();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            AbstractHttpConnection.this.onIdleTimeout();
            return true;
        }
    }

    private final class MultimodeExecutor
    implements IMultimodeExecutor {
        private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();

        private MultimodeExecutor() {
        }

        public void processMultithreaded(Runnable task) {
            this.taskQueue.performMultiThreaded(task, AbstractHttpConnection.this.getWorkerpool());
        }

        public void processNonthreaded(Runnable task) {
            this.taskQueue.performNonThreaded(task, AbstractHttpConnection.this.getWorkerpool());
        }
    }

    protected static final class DataSourceSinkPair {
        private NonBlockingBodyDataSource bodyDataSource = null;
        private BodyDataSink bodyDataSink = null;

        DataSourceSinkPair(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) {
            this.bodyDataSource = bodyDataSource;
            this.bodyDataSink = bodyDataSink;
        }

        public NonBlockingBodyDataSource getBodyDataSource() {
            return this.bodyDataSource;
        }

        public BodyDataSink getBodyDataSink() {
            return this.bodyDataSink;
        }
    }

    protected static interface IMultimodeExecutor {
        public void processMultithreaded(Runnable var1);

        public void processNonthreaded(Runnable var1);
    }

    protected static interface IMessageHandler {
        public void onMessage(IHttpMessage var1) throws IOException;

        public void onException(IOException var1);

        public boolean isBodylessMessageExpected();
    }

    private static final class NullMessageWriter
    implements IMessageWriter {
        private NullMessageWriter() {
        }

        public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
        }

        public void close() throws IOException {
        }

        public void destroy() {
        }

        public boolean isNetworkEndpoint() {
            return false;
        }

        public int getPendingWriteDataSize() {
            return 0;
        }
    }

    private static final class MessageWriter
    implements IMessageWriter {
        private NonBlockingBodyDataSource bodyDataSource = null;
        private IBodyDataHandler bodyDataHandler = null;

        public MessageWriter(IBodyDataHandler bodyDataHandler, String encoding) {
            this.bodyDataHandler = bodyDataHandler;
            this.bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, encoding);
        }

        public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
            this.bodyDataSource.append(isContentImmutable, bodyData, completionHandler);
            this.bodyDataHandler.onData(this.bodyDataSource);
        }

        public void close() throws IOException {
            this.bodyDataSource.close();
            this.bodyDataHandler.onData(this.bodyDataSource);
        }

        public void destroy() {
            this.bodyDataSource.destroy();
            this.bodyDataHandler.onData(this.bodyDataSource);
        }

        public boolean isNetworkEndpoint() {
            return false;
        }

        public int getPendingWriteDataSize() {
            return 0;
        }
    }

    @Execution(value=0)
    private static final class BodyCloseListener
    implements IBodyCloseListener {
        private Runnable task = null;

        public BodyCloseListener(Runnable task) {
            this.task = task;
        }

        public void onClose() throws IOException {
            this.task.run();
        }
    }
}

