/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class UpdateWhenDisabled {
    private final Map<EntityID, ViewEntity> _viewEntities;
    private final Map<LinkID, ViewLink> _viewLinks;
    private final GraphStructureReader _modelStructureReader;
    private final GraphDataStoreReader _modelDataReader;
    private final Map<EntityID, EntityID> _modelEntityToViewEntity;
    private final Map<LinkID, LinkID> _modelLinkToViewLink;
    private final Set<EntityID> _viewEntitiesWithoutLinks;

    UpdateWhenDisabled(Map<EntityID, ViewEntity> viewEntities, Map<LinkID, ViewLink> viewLinks, GraphDataStoreReader modelDataReader, GraphStructureReader modelStructureReader, Map<EntityID, EntityID> modelEntityToViewEntity, Map<LinkID, LinkID> modelLinkToViewLink, Set<EntityID> viewEntitiesWithoutLinks) {
        this._viewEntities = viewEntities;
        this._viewLinks = viewLinks;
        this._modelDataReader = modelDataReader;
        this._modelStructureReader = modelStructureReader;
        this._modelEntityToViewEntity = modelEntityToViewEntity;
        this._modelLinkToViewLink = modelLinkToViewLink;
        this._viewEntitiesWithoutLinks = viewEntitiesWithoutLinks;
    }

    private void updateLinks(GraphStructureMods structureMods) throws GraphStoreException {
        EntityID targetID;
        EntityID sourceID;
        LinkEntityIDs value;
        LinkID link;
        Map linkIdsAdded = this._modelStructureReader.getEntities((Collection)structureMods.getLinksAdded());
        for (Map.Entry entry : linkIdsAdded.entrySet()) {
            LinkID key = (LinkID)entry.getKey();
            LinkEntityIDs value2 = (LinkEntityIDs)entry.getValue();
            this._viewLinks.put(key, new ViewLink(value2));
            this._modelLinkToViewLink.put(key, key);
        }
        Map linkIdsRemoved = structureMods.getLinksRemoved();
        Set linkIdsRemovedKeySet = linkIdsRemoved.keySet();
        this._viewLinks.keySet().removeAll(linkIdsRemovedKeySet);
        this._modelLinkToViewLink.keySet().removeAll(linkIdsRemovedKeySet);
        for (Map.Entry entry : linkIdsAdded.entrySet()) {
            link = (LinkID)entry.getKey();
            value = (LinkEntityIDs)entry.getValue();
            sourceID = value.getSourceID();
            targetID = value.getTargetID();
            EntityLinks allLinksSource = this._viewEntities.get(sourceID).getAllLinks();
            allLinksSource.getModelOutgoingLinks().add(link);
            allLinksSource.getViewOutgoingLinks().add(link);
            EntityLinks allLinksTarget = this._viewEntities.get(targetID).getAllLinks();
            allLinksTarget.getModelIncomingLinks().add(link);
            allLinksTarget.getViewIncomingLinks().add(link);
        }
        for (Map.Entry entry : linkIdsRemoved.entrySet()) {
            EntityLinks allLinks;
            link = (LinkID)entry.getKey();
            value = (LinkEntityIDs)entry.getValue();
            sourceID = value.getSourceID();
            targetID = value.getTargetID();
            ViewEntity sourceViewEntity = this._viewEntities.get(sourceID);
            ViewEntity targetViewEntity = this._viewEntities.get(targetID);
            if (sourceViewEntity != null) {
                allLinks = sourceViewEntity.getAllLinks();
                allLinks.getModelOutgoingLinks().remove(link);
                allLinks.getViewOutgoingLinks().remove(link);
            }
            if (targetViewEntity == null) continue;
            allLinks = targetViewEntity.getAllLinks();
            allLinks.getModelIncomingLinks().remove(link);
            allLinks.getViewIncomingLinks().remove(link);
        }
    }

    private void updateEntities(GraphStructureMods structureMods) throws GraphStoreException {
        Set entitiesAdded = structureMods.getEntitiesAdded();
        Map incoming = this._modelStructureReader.getIncoming((Collection)entitiesAdded);
        Map outgoing = this._modelStructureReader.getOutgoing((Collection)entitiesAdded);
        Map entityTypes = this._modelDataReader.getEntityTypes((Collection)entitiesAdded);
        for (EntityID entityID : entitiesAdded) {
            Set incomingLinks = (Set)incoming.get(entityID);
            Set outgoingLinks = (Set)outgoing.get(entityID);
            EntityLinks viewAndModelLinks = new EntityLinks(incomingLinks, outgoingLinks, new HashSet<LinkID>(incomingLinks), new HashSet<LinkID>(outgoingLinks));
            ViewEntity viewEntity = new ViewEntity((String)entityTypes.get(entityID), viewAndModelLinks);
            this._viewEntities.put(entityID, viewEntity);
            this._modelEntityToViewEntity.put(entityID, entityID);
            if (viewAndModelLinks.hasViewOrModelLinks()) continue;
            this._viewEntitiesWithoutLinks.add(entityID);
        }
        this._viewEntities.keySet().removeAll(structureMods.getEntitiesRemoved());
        this._modelEntityToViewEntity.keySet().removeAll(structureMods.getEntitiesRemoved());
        this._viewEntitiesWithoutLinks.removeAll(structureMods.getEntitiesRemoved());
    }

    GraphStructureMods update(GraphStructureMods structureMods) throws GraphStoreException {
        if (structureMods != null) {
            this.updateEntities(structureMods);
            this.updateLinks(structureMods);
        }
        return structureMods;
    }
}

