/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.IconSize;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openide.filesystems.FileObject;

public class CompositeIconRegistry
extends IconRegistry {
    private final IconRegistry[] _iconRegistries;
    private IconRegistry _writeDelegate;

    public CompositeIconRegistry(IconRegistry ... iconRegistries) {
        this._iconRegistries = iconRegistries;
        this._writeDelegate = this._iconRegistries[0];
    }

    public IconRegistry[] getRegistries() {
        return this._iconRegistries;
    }

    public void setWriteDelegate(IconRegistry writeDelegate) {
        this._writeDelegate = writeDelegate;
    }

    public IconRegistry getWriteDelegate() {
        return this._writeDelegate;
    }

    @Override
    public RegistryIcon addFromImages(String category, String iconName, Map<IconSize, Image> iconImages) throws IOException {
        return this._writeDelegate.addFromImages(category, iconName, iconImages);
    }

    @Override
    public RegistryIcon addFromFiles(String category, String iconName, Map<IconSize, FileObject> iconFiles) throws IOException {
        return this._writeDelegate.addFromFiles(category, iconName, iconFiles);
    }

    @Override
    protected void removeIcon(RegistryIcon icon) throws IOException {
        this._writeDelegate.remove(icon);
    }

    @Override
    public void removeCategory(String category) throws IOException {
        this._writeDelegate.removeCategory(category);
    }

    @Override
    public RegistryIcon rename(RegistryIcon icon, String newName) throws IOException {
        return this._writeDelegate.rename(icon, newName);
    }

    @Override
    public void replace(RegistryIcon icon, IconSize size, BufferedImage image) throws IOException {
        this._writeDelegate.replace(icon, size, image);
    }

    @Override
    public void setAliases(RegistryIcon icon, Set<String> aliases) throws IOException {
        this._writeDelegate.setAliases(icon, aliases);
    }

    @Override
    public void addAlias(RegistryIcon icon, String alias) throws IOException {
        this._writeDelegate.addAlias(icon, alias);
    }

    @Override
    public void removeAlias(RegistryIcon icon, String alias) throws IOException {
        this._writeDelegate.removeAlias(icon, alias);
    }

    @Override
    public void setHubItems(RegistryIcon icon, Set<String> hubItems) throws IOException {
        this._writeDelegate.setHubItems(icon, hubItems);
    }

    @Override
    public void addHubItem(RegistryIcon icon, String hubItem) throws IOException {
        this._writeDelegate.addHubItem(icon, hubItem);
    }

    @Override
    public void removeHubItem(RegistryIcon icon, String hubItem) throws IOException {
        this._writeDelegate.removeHubItem(icon, hubItem);
    }

    @Override
    public List<RegistryIcon> getIcons() {
        return this.getIcons(IconRegistry::getIcons);
    }

    @Override
    public List<RegistryIcon> getIcons(String category) {
        return this.getIcons((IconRegistry registry) -> registry.getIcons(category));
    }

    private List<RegistryIcon> getIcons(Function<IconRegistry, List<RegistryIcon>> registryIcons) {
        return Arrays.stream(this._iconRegistries).map(registryIcons::apply).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean contains(RegistryIcon icon) {
        for (IconRegistry registry : this._iconRegistries) {
            if (!registry.contains(icon)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        for (IconRegistry iconRegistry : this._iconRegistries) {
            categories.addAll(iconRegistry.getCategories());
        }
        return categories;
    }

    @Override
    public Set<String> getIconNames(String category) {
        HashSet<String> names = new HashSet<String>();
        for (IconRegistry iconRegistry : this._iconRegistries) {
            Set<String> iconNames = iconRegistry.getIconNames(category);
            if (iconNames == null) continue;
            names.addAll(iconNames);
        }
        return names;
    }

    @Override
    public Optional<Image> loadImage(RegistryIcon icon, IconSize size) {
        return Arrays.stream(this._iconRegistries).map(registry -> registry.loadImage(icon, size)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._writeDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._writeDelegate.removePropertyChangeListener(listener);
    }
}

